(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1805712,      30707]
NotebookOptionsPosition[   1802892,      30634]
NotebookOutlinePosition[   1803563,      30657]
CellTagsIndexPosition[   1803520,      30654]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}],
   FontSize->12], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N5", ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[Xi]", "2"]}], ")"}], "*", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{"1", "-", "\[Eta]"}], "2"], ")"}]}]}], ";", 
  RowBox[{"N6", ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[Eta]", "2"]}], ")"}], "*", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{"1", "+", "\[Xi]"}], "2"], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N7", ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Xi]", "2"]}], ")"}], "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "+", "\[Eta]"}], "2"], ")"}]}]}], ";", 
   RowBox[{"N8", ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Eta]", "2"]}], ")"}], "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "-", "\[Xi]"}], "2"], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1PrviDeo", ":=", 
   RowBox[{
    FractionBox["1", "4"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Xi]"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Eta]"}], ")"}]}]}], ";", 
  RowBox[{"N2PrviDeo", ":=", 
   RowBox[{
    FractionBox["1", "4"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Eta]"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N3PrviDeo", ":=", 
    RowBox[{
     FractionBox["1", "4"], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Xi]"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Eta]"}], ")"}]}]}], ";", 
   RowBox[{"N4PrviDeo", ":=", 
    RowBox[{
     FractionBox["1", "4"], "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Xi]"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Eta]"}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1DrugiDeo", ":=", 
   RowBox[{"N1PrviDeo", "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N5"}]}]}], ";", 
  RowBox[{"N2DrugiDeo", ":=", 
   RowBox[{"N2PrviDeo", "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N5"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N3DrugiDeo", ":=", 
    RowBox[{"N3PrviDeo", "-", 
     RowBox[{
      FractionBox["1", "2"], "*", "N6"}]}]}], ";", 
   RowBox[{"N4DrugiDeo", ":=", 
    RowBox[{"N4PrviDeo", "-", 
     RowBox[{
      FractionBox["1", "2"], "*", "N7"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1Kompletno", ":=", 
   RowBox[{"N1DrugiDeo", "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N8"}]}]}], ";", 
  RowBox[{"N2Kompletno", ":=", 
   RowBox[{"N2DrugiDeo", "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N6"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N3Kompletno", ":=", 
    RowBox[{"N3DrugiDeo", "-", 
     RowBox[{
      FractionBox["1", "2"], "*", "N7"}]}]}], ";", 
   RowBox[{"N4Kompletno", ":=", 
    RowBox[{"N4DrugiDeo", "-", 
     RowBox[{
      FractionBox["1", "2"], "*", "N8"}]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N1Kompletno", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N1Kompletno", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N2Kompletno", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N2Kompletno", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N3Kompletno", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N3Kompletno", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N4Kompletno", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N4Kompletno", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N5 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N5", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N5 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N5", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N6 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N6", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N6 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N6", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N7 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N7", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N7 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N7", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N8 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N8", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N8 = \>\"", ",", 
    RowBox[{"ExpandAll", "[", 
     RowBox[{"N8", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Xi]", "\[Rule]", 
         FractionBox[
          RowBox[{"x", "-", "xT"}], "a"]}], ",", 
        RowBox[{"\[Eta]", "\[Rule]", 
         FractionBox[
          RowBox[{"y", "-", "yT"}], "b"]}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aa", ":=", "1"}], ";", 
  RowBox[{"bb", ":=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stil1", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Opacity", "[", "0.3", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"Mesh", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     "             ", 
     RowBox[{"BoundaryStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", "\[Eta]", ",", "z"}], "}"}], ",", 
        RowBox[{"GrayLevel", "[", "0.8", "]"}]}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gOsnovaPravougaonika", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"0", "*", "\[Xi]", "*", "\[Eta]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil1", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stil2", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Opacity", "[", "0.3", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"Mesh", "\[Rule]", "20"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Gray", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"BoundaryStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", "\[Eta]", ",", "z"}], "}"}], ",", 
        RowBox[{"GrayLevel", "[", 
         RowBox[{"0.8", "*", "z"}], "]"}]}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN1PrviDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N1PrviDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN1DrugiDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N1DrugiDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN1Kompletno", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N1Kompletno", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN2PrviDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N2PrviDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN2DrugiDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N2DrugiDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN2Kompletno", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N2Kompletno", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN3PrviDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N3PrviDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN3DrugiDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N3DrugiDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN3Kompletno", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N3Kompletno", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN4PrviDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N4PrviDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN4DrugiDeo", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N4DrugiDeo", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN4Kompletno", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N4Kompletno", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN5", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N5", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN6", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N6", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN7", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N7", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gN8", ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N8", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "aa"}], ",", "aa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "bb"}], ",", "bb"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stil3", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
     "             ", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.3", ",", 
        RowBox[{"-", "2.4"}], ",", "2.0"}], "}"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"Background", "\[Rule]", "White"}], ",", "\[IndentingNewLine]", 
     "            ", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"600", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]",
      "            ", 
     RowBox[{"Axes", "->", 
      RowBox[{"{", 
       RowBox[{"False", ",", " ", "False", ",", " ", "False"}], "}"}]}], ",", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]",
      "            ", 
     RowBox[{"Boxed", "\[Rule]", "True"}], ",", 
     RowBox[{"BoxStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"{", 
        RowBox[{"Black", ",", 
         RowBox[{"Thickness", "[", "0.003", "]"}]}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "            ", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "30"}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1,L = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N1PrviDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN1PrviDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N1DrugiDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN1DrugiDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<N1 = N1,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 - \
\!\(\*FractionBox[\(1\), \(2\)]\)N8 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N1Kompletno", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN1Kompletno", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2,L = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N2PrviDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN2PrviDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N2DrugiDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN2DrugiDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<N2 = N2,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 - \
\!\(\*FractionBox[\(1\), \(2\)]\)N6 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N2Kompletno", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN2Kompletno", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3,L = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N3PrviDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN3PrviDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3,L - \!\(\*FractionBox[\(1\), \(2\)]\)N6 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N3DrugiDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN3DrugiDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<N3 = N3,L - \!\(\*FractionBox[\(1\), \(2\)]\)N6 - \
\!\(\*FractionBox[\(1\), \(2\)]\)N7 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N3Kompletno", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN3Kompletno", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4,L = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N4PrviDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN4PrviDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4,L - \!\(\*FractionBox[\(1\), \(2\)]\)N7 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N4DrugiDeo", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN4DrugiDeo", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<N4 = N4,L - \!\(\*FractionBox[\(1\), \(2\)]\)N7 - \
\!\(\*FractionBox[\(1\), \(2\)]\)N8 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N4Kompletno", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN4Kompletno", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N5 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N5", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN5", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N6 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N6", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN6", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N7 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N7", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN7", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N8 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", "N8", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gOsnovaPravougaonika", ",", "gN8", ",", 
   RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Exit", "[", "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.671285218561768*^9, 3.6712852224778795`*^9}, {
   3.6712853507781982`*^9, 3.6712853533627048`*^9}, {3.6712855156956444`*^9, 
   3.6712856569865522`*^9}, {3.67128569827171*^9, 3.6712858122335777`*^9}, {
   3.671285854529786*^9, 3.6712859397580795`*^9}, 3.671286029911565*^9, {
   3.67128621048756*^9, 3.671286417539914*^9}, {3.671286456937516*^9, 
   3.671286511641947*^9}, {3.6712865498084764`*^9, 3.671286641308779*^9}, {
   3.671286679408077*^9, 3.671286680392885*^9}, {3.6712868347312326`*^9, 
   3.6712870316508045`*^9}, {3.6712870631202908`*^9, 3.671287172719783*^9}, {
   3.671287218035914*^9, 3.6712872453120375`*^9}, {3.6712872857306986`*^9, 
   3.671287480913745*^9}, {3.67128760822691*^9, 3.671287615294515*^9}, {
   3.671287658983341*^9, 3.671287664085622*^9}, {3.671287720015352*^9, 
   3.6712878112462034`*^9}, {3.6712878430778933`*^9, 3.671288010857177*^9}, {
   3.6712880484430227`*^9, 3.6712880832353263`*^9}, {3.6712881190409427`*^9, 
   3.6712882842351017`*^9}, {3.671288322262892*^9, 3.6712886145514774`*^9}, {
   3.6712886499296465`*^9, 3.6712886964168*^9}, {3.6712887356531954`*^9, 
   3.6712887796809597`*^9}, {3.671288846683859*^9, 3.6712888540468025`*^9}, {
   3.671289010278998*^9, 3.6712890786229305`*^9}, {3.671289116596269*^9, 
   3.671289336057767*^9}, {3.6712893733520656`*^9, 3.6712894058850164`*^9}, {
   3.671289450951722*^9, 3.671289516751732*^9}, {3.6712895713626103`*^9, 
   3.6712897779221067`*^9}, {3.6712898803641434`*^9, 
   3.6712899069621696`*^9}, {3.6712900872947817`*^9, 3.671290110523388*^9}, {
   3.671290142906954*^9, 3.671290242433835*^9}, {3.6712907191559258`*^9, 
   3.6712907227028365`*^9}, {3.6712915529308906`*^9, 
   3.6712915541158876`*^9}, {3.6712915849831967`*^9, 
   3.6712915884658127`*^9}, {3.6712918668742604`*^9, 
   3.6712918948896437`*^9}, {3.6713638866615114`*^9, 
   3.6713639267959366`*^9}, {3.6713639654021297`*^9, 3.671364108649173*^9}, {
   3.671364163210293*^9, 3.671364170181383*^9}, 3.6713642026152887`*^9, 
   3.6713642576706853`*^9, {3.6713643072988725`*^9, 3.671364539558816*^9}, {
   3.671364580433095*^9, 3.6713645989780054`*^9}, {3.6713647080053787`*^9, 
   3.6713647472653875`*^9}, {3.6713647778689423`*^9, 3.6713647784323025`*^9}, 
   3.6713648706601353`*^9, {3.6713649157743363`*^9, 3.671364916136832*^9}, {
   3.6713649473896675`*^9, 3.671364998649497*^9}, {3.6713650955230904`*^9, 
   3.6713651050399957`*^9}, {3.671365304869897*^9, 3.6713653248734503`*^9}, {
   3.671365354956499*^9, 3.6713653614089217`*^9}, {3.671365396020467*^9, 
   3.671365431412361*^9}, {3.6713654780513506`*^9, 3.671365521483403*^9}, {
   3.6713656732056217`*^9, 3.6713659212539225`*^9}, {3.671426518830373*^9, 
   3.671426525233269*^9}, {3.6717741921281157`*^9, 3.671774212176962*^9}, {
   3.6717789587768874`*^9, 3.671779013165189*^9}, {3.6717791379871535`*^9, 
   3.671779186932439*^9}, {3.6717792438884296`*^9, 3.6717793035061707`*^9}, {
   3.671779347320695*^9, 3.671779450410405*^9}, {3.6717794989769335`*^9, 
   3.671779604387034*^9}, {3.671779661628614*^9, 3.671779707251586*^9}, {
   3.671779778085601*^9, 3.6717797983356867`*^9}, {3.6717799029052763`*^9, 
   3.6717799639934483`*^9}, {3.671780311972494*^9, 3.67178040856621*^9}, {
   3.671780639584324*^9, 3.6717807654167814`*^9}, {3.671780807517355*^9, 
   3.6717810976553736`*^9}, {3.6717811317585583`*^9, 3.671781206914386*^9}, {
   3.671781307239745*^9, 3.6717815025710073`*^9}, {3.671811932819356*^9, 
   3.6718122482552824`*^9}, {3.671812290688249*^9, 3.6718123623678527`*^9}, {
   3.671812420006447*^9, 3.671812446252369*^9}, {3.6718124774740324`*^9, 
   3.6718127818101397`*^9}, {3.6718128374554253`*^9, 3.67181294308043*^9}, {
   3.6718129769926376`*^9, 3.671813025462169*^9}, {3.6718130554713297`*^9, 
   3.6718132072752457`*^9}, {3.6718132726530647`*^9, 
   3.6718133742146673`*^9}, {3.6718134566132936`*^9, 3.671813580997898*^9}, {
   3.6718136154354467`*^9, 3.671813693988187*^9}, {3.671813739948841*^9, 
   3.671813787935314*^9}, {3.671813823417328*^9, 3.6718138250337043`*^9}, {
   3.6718138586745963`*^9, 3.671813895540545*^9}, {3.671814004842018*^9, 
   3.671814015478223*^9}, {3.6718199742193604`*^9, 3.6718200065635724`*^9}, {
   3.671820129618413*^9, 3.671820269119842*^9}, {3.671820338812415*^9, 
   3.6718203547218266`*^9}, {3.6718204023935676`*^9, 3.671820483971063*^9}, {
   3.671820584744954*^9, 3.6718206394933834`*^9}, {3.6718206805555696`*^9, 
   3.671820815156568*^9}, {3.6718208744598036`*^9, 3.6718209332828016`*^9}, {
   3.6718209668721514`*^9, 3.671820989211153*^9}, {3.671821061964681*^9, 
   3.671821111418125*^9}, {3.6718211845255175`*^9, 3.671821206509573*^9}, {
   3.6718212509793873`*^9, 3.6718215076635666`*^9}, {3.6718215393771024`*^9, 
   3.671821600321368*^9}, {3.6718216533057375`*^9, 3.671821663539055*^9}, {
   3.6718217255988903`*^9, 3.6718217759507914`*^9}, {3.6718218311602097`*^9, 
   3.6718218478347163`*^9}, {3.671821894305772*^9, 3.6718219297300587`*^9}, {
   3.6718221910898223`*^9, 3.6718222901567526`*^9}, {3.6718223518925424`*^9, 
   3.6718225175328913`*^9}, 3.671822579147814*^9, {3.67182269184648*^9, 
   3.6718228493494787`*^9}, {3.6718229830961466`*^9, 
   3.6718229872818766`*^9}, {3.6718230654528136`*^9, 3.671823141868691*^9}, {
   3.67182320143335*^9, 3.671823240288227*^9}, {3.6718232919420924`*^9, 
   3.671823308103662*^9}, {3.6718234025042424`*^9, 3.671823424530915*^9}, {
   3.6718236946353188`*^9, 3.6718237445504704`*^9}, {3.6718237783912354`*^9, 
   3.67182381086469*^9}, {3.6718239024213147`*^9, 3.6718239490975456`*^9}, {
   3.6718239959855213`*^9, 3.671824016390843*^9}, {3.6718240594319086`*^9, 
   3.671824124689901*^9}, {3.671824195488669*^9, 3.6718242009410715`*^9}, {
   3.6718242333409853`*^9, 3.671824252207259*^9}, {3.6718551784605937`*^9, 
   3.6718553262731314`*^9}, {3.6718553762594056`*^9, 
   3.6718554381127787`*^9}, {3.6718554853514585`*^9, 
   3.6718555283276367`*^9}, {3.671855593829836*^9, 3.671855603579984*^9}, {
   3.671855715187302*^9, 3.6718557398636*^9}, {3.6718557699019794`*^9, 
   3.6718557714182944`*^9}, {3.671855809941201*^9, 3.671855840050542*^9}, {
   3.6718559442812276`*^9, 3.6718559572800417`*^9}, {3.671856009468233*^9, 
   3.6718560570520725`*^9}, {3.671856101122105*^9, 3.6718561195348864`*^9}, {
   3.6718561626039658`*^9, 3.671856214746307*^9}, {3.671856272127247*^9, 
   3.6718562967772355`*^9}, 3.6718563310219126`*^9, {3.671856365488142*^9, 
   3.6718564155486126`*^9}, {3.671856458084223*^9, 3.671856474950062*^9}, {
   3.6718565060179415`*^9, 3.6718565467233124`*^9}, {3.671856613116184*^9, 
   3.671856653242087*^9}, {3.6718567121782827`*^9, 3.671856741618887*^9}, {
   3.6718567808982434`*^9, 3.6718569254495945`*^9}, {3.6718570757330837`*^9, 
   3.6718570855854588`*^9}, {3.6718571496350346`*^9, 
   3.6718571772586803`*^9}, {3.6718572291595306`*^9, 
   3.6718573207738256`*^9}, {3.6718574423460197`*^9, 3.671857466454465*^9}, {
   3.67185749711569*^9, 3.671857606936226*^9}, {3.671857655201708*^9, 
   3.671857686448434*^9}, {3.671857846702374*^9, 3.671857853955722*^9}, {
   3.67185788974846*^9, 3.671857900011544*^9}, {3.6718580239176764`*^9, 
   3.6718580246959057`*^9}, {3.671860089122366*^9, 3.671860175990391*^9}, {
   3.6718602160513296`*^9, 3.6718603397783556`*^9}, {3.6718604664273148`*^9, 
   3.6718605111823053`*^9}, {3.6718605670257945`*^9, 
   3.6718606463989315`*^9}, {3.6718606832246585`*^9, 3.6718606992270565`*^9}, 
   3.6718609088190937`*^9, {3.671860998007786*^9, 3.671861005307844*^9}, {
   3.6718617100985355`*^9, 3.671861714417272*^9}, {3.6718942709914985`*^9, 
   3.671894335625294*^9}, {3.6718949699354415`*^9, 3.671894970088913*^9}, {
   3.6718987476369715`*^9, 3.6718987483997793`*^9}, 3.6718989474868484`*^9, {
   3.671902181506486*^9, 3.6719022068810854`*^9}, {3.6719028263980923`*^9, 
   3.671902854322629*^9}, 3.6719521015513687`*^9, {3.6719830084599595`*^9, 
   3.671983021329599*^9}, {3.764850539337758*^9, 3.76485054025616*^9}, {
   3.764850635119614*^9, 3.7648507116432886`*^9}, 3.7648507719598923`*^9, 
   3.764850839990103*^9, {3.7648512978726315`*^9, 3.764851298837706*^9}, 
   3.764851811456026*^9, {3.7648525225664234`*^9, 3.7648526225140066`*^9}, {
   3.764852657875308*^9, 3.7648526590160475`*^9}, {3.7648527384406643`*^9, 
   3.7648527831957755`*^9}, {3.7648528351164117`*^9, 
   3.7648532582045083`*^9}, {3.764853356762643*^9, 3.7648534199999313`*^9}, {
   3.7648534522893753`*^9, 3.764853459246668*^9}, {3.764853492254261*^9, 
   3.764853543273456*^9}, {3.764853599536957*^9, 3.764853607188237*^9}, {
   3.76485376817686*^9, 3.7648538015875854`*^9}, {3.764853835567177*^9, 
   3.764853915326338*^9}, {3.7648539702145042`*^9, 3.764853971618474*^9}, {
   3.7648540847665024`*^9, 3.7648540857002497`*^9}, {3.7648542209112463`*^9, 
   3.7648542371406193`*^9}, {3.764854274005555*^9, 3.7648542931432734`*^9}, {
   3.764854323581976*^9, 3.764854444811792*^9}, 3.764854562667125*^9, 
   3.7648546292653484`*^9, {3.7648548581264105`*^9, 3.7648548601479225`*^9}, {
   3.7657752466623774`*^9, 3.7657752473325505`*^9}, {3.7658813395916853`*^9, 
   3.765881448289203*^9}, {3.765881488813991*^9, 3.765881556276971*^9}, {
   3.765882163004282*^9, 3.7658821652098007`*^9}, {3.7658823357784305`*^9, 
   3.765882406763747*^9}, {3.765882497851982*^9, 3.765882685234913*^9}, {
   3.7659513069574285`*^9, 3.7659513076216183`*^9}, 3.7659515949117403`*^9, {
   3.7686433368596773`*^9, 3.768643345823449*^9}, {3.7888683350258455`*^9, 
   3.788868375576277*^9}, {3.78886841172418*^9, 3.788868427260683*^9}, {
   3.7888691907912993`*^9, 3.7888692010860343`*^9}, {3.788869835867634*^9, 
   3.7888698712882147`*^9}, {3.7888712404301295`*^9, 
   3.7888713105880127`*^9}, {3.7888713832481165`*^9, 
   3.7888714096363935`*^9}, {3.788871445963838*^9, 3.788871454895713*^9}, {
   3.788875011781168*^9, 3.7888750166433363`*^9}, {3.788875091226059*^9, 
   3.7888753903779535`*^9}, {3.788875424680818*^9, 3.788875458243658*^9}, {
   3.788875549741234*^9, 3.7888755925845265`*^9}, {3.7888756459069138`*^9, 
   3.788875648762*^9}, {3.7888757070779734`*^9, 3.7888757421371164`*^9}, {
   3.788875803540922*^9, 3.788875855002714*^9}, {3.7888759030099225`*^9, 
   3.7888759293119535`*^9}, {3.7888759694250717`*^9, 
   3.7888759818829727`*^9}, {3.788876033942625*^9, 3.7888760342602825`*^9}, {
   3.788876092120573*^9, 3.78887613288743*^9}, {3.788876175376999*^9, 
   3.78887625555857*^9}, 3.7888763669045854`*^9, {3.7888764125905514`*^9, 
   3.788876821599981*^9}, {3.7888768539380307`*^9, 3.788876937039981*^9}, {
   3.788876978329454*^9, 3.7888769976538086`*^9}, {3.78887703002542*^9, 
   3.7888772036665*^9}, {3.7888772573958917`*^9, 3.7888774867392893`*^9}, {
   3.788878060292031*^9, 3.7888780849149446`*^9}, {3.788878116869171*^9, 
   3.7888782320923886`*^9}, {3.788878266245311*^9, 3.7888784384288692`*^9}, {
   3.78887849478141*^9, 3.7888785117391*^9}, {3.788878600777542*^9, 
   3.7888787355454855`*^9}, {3.788878805788706*^9, 3.7888788594279146`*^9}, {
   3.788878937411618*^9, 3.788878993699915*^9}, {3.788879044385849*^9, 
   3.7888790570286493`*^9}, {3.7889277027066326`*^9, 3.78892774620237*^9}, {
   3.7889280701483192`*^9, 3.788928141080653*^9}, {3.7889281827532663`*^9, 
   3.788928193720052*^9}, {3.78892826653611*^9, 3.7889283048322763`*^9}, {
   3.7889284990179915`*^9, 3.7889284995061855`*^9}, {3.788928586159482*^9, 
   3.788928624278353*^9}, {3.78892865966041*^9, 3.78892871630365*^9}, {
   3.788929867846249*^9, 3.7889298684112325`*^9}, {3.788930262719632*^9, 
   3.7889305267227263`*^9}, {3.7889306147870703`*^9, 
   3.7889306604723024`*^9}, {3.7889307132712784`*^9, 3.788930756268108*^9}, {
   3.7889307903948064`*^9, 3.7889307939007564`*^9}, {3.7889308523866963`*^9, 
   3.7889309434564586`*^9}, {3.788931030425323*^9, 3.788931162231959*^9}, {
   3.7889312823834467`*^9, 3.7889312840554113`*^9}, {3.788931315585106*^9, 
   3.7889314880972548`*^9}, {3.7889315182746763`*^9, 3.788931626692915*^9}, {
   3.7889316638505125`*^9, 3.788931695556734*^9}, {3.788931750353458*^9, 
   3.7889317937618065`*^9}, {3.7889318657636456`*^9, 3.788932122897314*^9}, {
   3.788932208111255*^9, 3.7889322593392577`*^9}, {3.7889323170669365`*^9, 
   3.788932346935416*^9}, {3.7889324258400745`*^9, 3.788932427028426*^9}, {
   3.7889325116645536`*^9, 3.7889325652719326`*^9}, {3.788932601249574*^9, 
   3.7889326295904965`*^9}, 3.788932663515993*^9, {3.7889327225289545`*^9, 
   3.7889327371778603`*^9}, {3.7889327728234186`*^9, 
   3.7889327908741307`*^9}, {3.7889328826694326`*^9, 
   3.7889329132232895`*^9}, {3.7889330725275407`*^9, 
   3.7889330731056595`*^9}, {3.7889331032253304`*^9, 
   3.7889331051471972`*^9}, {3.7889336873689585`*^9, 3.788933860702362*^9}, {
   3.7889339034640613`*^9, 3.788934030376363*^9}, {3.7889340697034044`*^9, 
   3.7889341099545465`*^9}, {3.788934149700876*^9, 3.7889342132389355`*^9}, {
   3.788934264848363*^9, 3.7889342830738583`*^9}, {3.7889343132574725`*^9, 
   3.788934614429613*^9}, {3.788934663501567*^9, 3.788934686694477*^9}, {
   3.7889347411103125`*^9, 3.7889347925621305`*^9}, 3.7889348356393414`*^9, {
   3.788934880140425*^9, 3.7889348938515415`*^9}, {3.788934939486585*^9, 
   3.788935082930088*^9}, {3.7889351211501803`*^9, 3.7889351408905783`*^9}, 
   3.7889351741547246`*^9, {3.788935252884767*^9, 3.788935342188068*^9}, {
   3.7889354425502276`*^9, 3.788935490909715*^9}, {3.788935546590757*^9, 
   3.788935598585597*^9}, {3.788935745258687*^9, 3.7889358353096666`*^9}, {
   3.7889358756468916`*^9, 3.788935941789583*^9}, {3.788935973524351*^9, 
   3.7889360682046227`*^9}, {3.7889360994055986`*^9, 
   3.7889361965614214`*^9}, {3.788936229416624*^9, 3.788936281779401*^9}, {
   3.7889363167117624`*^9, 3.78893631727426*^9}, {3.788936350325221*^9, 
   3.7889363547881804`*^9}, 3.7889364043104343`*^9, {3.788936468283768*^9, 
   3.788936472783749*^9}, {3.788936550841318*^9, 3.7889365917246265`*^9}, {
   3.788936624923196*^9, 3.7889366623949423`*^9}, {3.788936713039298*^9, 
   3.7889367238542137`*^9}, 3.7889368492799854`*^9, {3.7889369499518933`*^9, 
   3.7889369500925183`*^9}, {3.788936983017535*^9, 3.7889370718366346`*^9}, {
   3.7889371058205967`*^9, 3.788937109070583*^9}, 3.7889372314799876`*^9, {
   3.7889373144715014`*^9, 3.7889374040086536`*^9}, {3.7889374377889977`*^9, 
   3.7889375105223885`*^9}, {3.7889375755687256`*^9, 
   3.7889376237265973`*^9}, {3.788937697449001*^9, 3.7889377313929405`*^9}, {
   3.788937814713395*^9, 3.7889378496023054`*^9}, {3.788937916908702*^9, 
   3.78893794647971*^9}, {3.7889379933369236`*^9, 3.7889380774623194`*^9}, {
   3.7889385634986362`*^9, 3.788938584419098*^9}, {3.788938642662367*^9, 
   3.7889387175439806`*^9}, {3.78893875173489*^9, 3.788938823010933*^9}, 
   3.788938853674123*^9, {3.7889388881523705`*^9, 3.7889389207902775`*^9}, {
   3.788938994410183*^9, 3.788939000930122*^9}, {3.7889390906451716`*^9, 
   3.788939103344173*^9}, {3.7889391357277517`*^9, 3.788939246151387*^9}, {
   3.7889393046677485`*^9, 3.7889393764003906`*^9}, {3.7889394113789015`*^9, 
   3.788939457843468*^9}, {3.7889395135611067`*^9, 3.7889397004651575`*^9}, {
   3.788939750862116*^9, 3.788939867939757*^9}, {3.788939905089368*^9, 
   3.7889399744039097`*^9}, {3.7889400251977015`*^9, 3.788940088711226*^9}, {
   3.7889401356048317`*^9, 3.7889401596426983`*^9}, {3.788940221678084*^9, 
   3.7889402299874115`*^9}, {3.788940266193453*^9, 3.788940266740344*^9}, {
   3.788940460823142*^9, 3.7889405816799746`*^9}, {3.7889406123770475`*^9, 
   3.7889408309900866`*^9}, {3.788940874956951*^9, 3.7889409673805532`*^9}, {
   3.7889410318378477`*^9, 3.788941047106982*^9}, {3.7889410866515417`*^9, 
   3.788941106266632*^9}, {3.7889411702337947`*^9, 3.7889412104324627`*^9}, {
   3.788941249957552*^9, 3.78894128222021*^9}, {3.788941320337202*^9, 
   3.788941416522251*^9}, {3.788941490738638*^9, 3.7889414908306336`*^9}, {
   3.7889415298528266`*^9, 3.788941678410945*^9}, {3.7889417129325294`*^9, 
   3.788941788358096*^9}, {3.7889418468701725`*^9, 3.788941855901862*^9}, {
   3.7889420651805534`*^9, 3.7889421161174326`*^9}, {3.7889421474732027`*^9, 
   3.7889422577717943`*^9}, {3.788942303617524*^9, 3.7889424714791937`*^9}, {
   3.788942519320487*^9, 3.788942594647809*^9}, {3.7889426356570315`*^9, 
   3.7889426692096815`*^9}, {3.788942703217082*^9, 3.78894270651571*^9}, {
   3.788942754963399*^9, 3.788942788869017*^9}, {3.7889428225684185`*^9, 
   3.7889430646928864`*^9}, {3.788943292588423*^9, 3.7889433432983217`*^9}, {
   3.7889448499168944`*^9, 3.7889448985276546`*^9}, {3.788944936174612*^9, 
   3.788944945156077*^9}, {3.7889449772776623`*^9, 3.7889450176829185`*^9}, {
   3.7889450663171453`*^9, 3.7889452744140944`*^9}, {3.7889453132757463`*^9, 
   3.7889455905750628`*^9}, {3.7889456691017303`*^9, 3.788945744113161*^9}, {
   3.7889458012545357`*^9, 3.788945850892818*^9}, {3.7889459012495317`*^9, 
   3.7889460897136855`*^9}, {3.7889461526720867`*^9, 3.788946265544243*^9}, {
   3.788946305278676*^9, 3.788946330675517*^9}, {3.7889463633885746`*^9, 
   3.7889464337150946`*^9}, {3.788946500555638*^9, 3.788946551090985*^9}, {
   3.788946607516986*^9, 3.7889467505657225`*^9}, 3.7889467892684407`*^9, {
   3.7889468444326906`*^9, 3.7889468456202016`*^9}, 3.788946879327982*^9, {
   3.788946967481017*^9, 3.7889471081995664`*^9}, {3.788947211933799*^9, 
   3.788947344984446*^9}, {3.7889473811507883`*^9, 3.7889474765330505`*^9}, {
   3.788947545103493*^9, 3.788947548684409*^9}, {3.789023061008133*^9, 
   3.7890232181868067`*^9}, {3.789023349713216*^9, 3.7890234902202873`*^9}, {
   3.7890235513195314`*^9, 3.7890235609296155`*^9}, {3.7890236002351155`*^9, 
   3.7890236611514444`*^9}, {3.7890238415336933`*^9, 3.789023864943338*^9}, {
   3.789023910818262*^9, 3.7890239198446064`*^9}, 3.7890241520480905`*^9, {
   3.7890241937357283`*^9, 3.789024335991862*^9}, {3.7890243854397326`*^9, 
   3.789024437110846*^9}, {3.7890245319719687`*^9, 3.7890245528745394`*^9}, {
   3.789024651954897*^9, 3.7890246989480934`*^9}, {3.7890247681577177`*^9, 
   3.789024780584651*^9}, {3.789024819295697*^9, 3.789024841085168*^9}, {
   3.789024876726943*^9, 3.789025071435512*^9}, {3.789025109168145*^9, 
   3.78902521049349*^9}, {3.789025326046049*^9, 3.7890253613823905`*^9}, {
   3.7890253995219755`*^9, 3.789025473728295*^9}, {3.789025509692209*^9, 
   3.789025560624873*^9}, {3.7890256437284265`*^9, 3.7890256442987905`*^9}, {
   3.789025699377643*^9, 3.7890257192177715`*^9}, 3.7890257537080913`*^9, {
   3.789025829125077*^9, 3.7890258334942102`*^9}, {3.7890260353542414`*^9, 
   3.7890260913879347`*^9}, {3.789026122237811*^9, 3.789026184378585*^9}, {
   3.789026236255331*^9, 3.789026296185978*^9}, {3.789026348791497*^9, 
   3.789026350982068*^9}, {3.789026388246945*^9, 3.7890263937229595`*^9}, {
   3.789026503954151*^9, 3.7890265773010025`*^9}, {3.789026610673023*^9, 
   3.7890266517928057`*^9}, {3.789026682706566*^9, 3.7890266929331837`*^9}, {
   3.7890267361999865`*^9, 3.7890267750484004`*^9}, {3.789026809354734*^9, 
   3.7890268472747054`*^9}, 3.7890269392315044`*^9, {3.7890269738174143`*^9, 
   3.7890270380120773`*^9}, {3.7890273573663845`*^9, 3.789027370153887*^9}, {
   3.789027408118063*^9, 3.7890274160788717`*^9}, {3.789027525128593*^9, 
   3.78902764598519*^9}, {3.789027677587797*^9, 3.78902772035088*^9}, {
   3.789027752076336*^9, 3.789027784393772*^9}, {3.7890278421195297`*^9, 
   3.789027848467891*^9}, {3.789027879366764*^9, 3.7890279162985106`*^9}, {
   3.7890279961287107`*^9, 3.7890280169665985`*^9}, {3.789028107735612*^9, 
   3.7890281128645277`*^9}, {3.789028147381074*^9, 3.7890282385724897`*^9}, {
   3.7890282725633082`*^9, 3.789028344810417*^9}, {3.7890283755451946`*^9, 
   3.789028450977661*^9}, {3.7890285031852913`*^9, 3.789028544713812*^9}, {
   3.7890324643380632`*^9, 3.7890325758188767`*^9}, {3.789032641633298*^9, 
   3.7890327427016582`*^9}, {3.7890328770077715`*^9, 3.78903307560835*^9}, {
   3.7890359318106427`*^9, 3.789035932008642*^9}, {3.7890379486146765`*^9, 
   3.789037949617454*^9}, {3.7890389089036064`*^9, 3.7890389245012107`*^9}, {
   3.7890390222777205`*^9, 3.789039032151469*^9}, {3.789039188247497*^9, 
   3.7890392652095337`*^9}, 3.7890394915092936`*^9, {3.7890400346546144`*^9, 
   3.78904005785102*^9}, {3.789042512727436*^9, 3.789042514015156*^9}, {
   3.789482782714414*^9, 3.7894827829331636`*^9}, {3.790843725813648*^9, 
   3.7908437749356413`*^9}, {3.790843945040861*^9, 3.7908441005349083`*^9}, {
   3.79084469742492*^9, 3.790844761357546*^9}, {3.7908449665374513`*^9, 
   3.7908449991981263`*^9}, {3.7908450309699793`*^9, 3.7908450502061787`*^9}, 
   3.7908451050400906`*^9, {3.7908451810277057`*^9, 3.7908451912383113`*^9}, {
   3.7908459034609966`*^9, 3.7908459507545223`*^9}, {3.7908461176431317`*^9, 
   3.7908461179595385`*^9}, {3.7908466019254465`*^9, 
   3.7908467198173857`*^9}, {3.7908468888399305`*^9, 3.790846934048202*^9}, {
   3.7908469712347713`*^9, 3.7908469716893024`*^9}, {3.7909079051042857`*^9, 
   3.7909079427643685`*^9}, {3.7909079922911572`*^9, 
   3.7909080021969166`*^9}, {3.790909985821327*^9, 3.790909988130271*^9}, {
   3.79091015267225*^9, 3.790910157717128*^9}, {3.790910376527751*^9, 
   3.790910397554235*^9}, {3.7909104284624796`*^9, 3.79091042966345*^9}, {
   3.7909105061275826`*^9, 3.790910544646642*^9}, 3.790910636663686*^9, {
   3.7909116893537993`*^9, 3.790911796894176*^9}, {3.7909118802965746`*^9, 
   3.7909119918098526`*^9}, {3.7909120472064967`*^9, 
   3.7909120518163867`*^9}, {3.790912083556612*^9, 3.7909122484765854`*^9}, {
   3.79091234368426*^9, 3.790912353491021*^9}, {3.79091250411734*^9, 
   3.7909125842433834`*^9}, {3.7909127387521677`*^9, 
   3.7909127967417574`*^9}, {3.790912993990937*^9, 3.790913023057994*^9}, {
   3.790913412647771*^9, 3.7909134167226667`*^9}, {3.7909134797871275`*^9, 
   3.790913489289897*^9}, {3.790917982265809*^9, 3.7909180243917828`*^9}, {
   3.790918108393732*^9, 3.790918180655965*^9}, {3.7909182264284935`*^9, 
   3.7909182440050645`*^9}, 3.790918318495246*^9, {3.7909183997362394`*^9, 
   3.790918458373805*^9}, {3.7909185646572123`*^9, 3.7909186324525566`*^9}, {
   3.790918679539407*^9, 3.7909188176440372`*^9}, {3.7909188550291224`*^9, 
   3.7909189021979685`*^9}, {3.790918942972975*^9, 3.7909189557166643`*^9}, {
   3.790919174693166*^9, 3.7909192475123887`*^9}, {3.7909193247367444`*^9, 
   3.7909193449602547`*^9}, {3.790919424704063*^9, 3.7909196150214195`*^9}, {
   3.7909196532074847`*^9, 3.7909196939474926`*^9}, {3.7909197945770335`*^9, 
   3.7909198069617333`*^9}, {3.7910160031863527`*^9, 3.791016018185157*^9}, {
   3.791016062809433*^9, 3.7910161733526535`*^9}, {3.7910162489452024`*^9, 
   3.7910162987569733`*^9}, 3.7910164041088047`*^9, 3.7910164598809657`*^9, {
   3.791016530198585*^9, 3.791016559444867*^9}, 3.791016615540489*^9, 
   3.7910166538957453`*^9, {3.7910167292092323`*^9, 3.791016809833393*^9}, {
   3.791016842714589*^9, 3.791016852083356*^9}, {3.791016925933322*^9, 
   3.791016955775276*^9}, {3.7910170628158436`*^9, 3.791017083568331*^9}, {
   3.7910172299547367`*^9, 3.7910172379405346`*^9}, {3.791017374516403*^9, 
   3.7910173867051*^9}, {3.7910185663183537`*^9, 3.7910185712192326`*^9}, {
   3.791018693041989*^9, 3.791018695316489*^9}, {3.7910187332527747`*^9, 
   3.791018842077097*^9}, {3.7910188791347103`*^9, 3.7910189053010674`*^9}, {
   3.791018955733124*^9, 3.7910189656588764`*^9}, {3.7910191941184196`*^9, 
   3.7910192183738227`*^9}, 3.791019260597212*^9, {3.791019295282355*^9, 
   3.791019295844343*^9}, {3.791089516569024*^9, 3.7910895229836683`*^9}, {
   3.7910896983826494`*^9, 3.7910897798056135`*^9}, 3.7910903537254095`*^9, {
   3.791090447668702*^9, 3.7910905437563124`*^9}, {3.791090585582284*^9, 
   3.7910905949060497`*^9}, {3.791090630341486*^9, 3.791090711377494*^9}, {
   3.7910908160329647`*^9, 3.791090816777946*^9}, {3.7910908939438047`*^9, 
   3.791090903904558*^9}, {3.791098107725418*^9, 3.7910982165441127`*^9}, {
   3.7910983423446846`*^9, 3.791098342719671*^9}, {3.7910995084959235`*^9, 
   3.7910995787372026`*^9}, {3.7911001164609833`*^9, 
   3.7911003039604096`*^9}, {3.7911003371110992`*^9, 3.791100355140659*^9}, {
   3.7911003874068613`*^9, 3.7911004045214443`*^9}, {3.7911004584201727`*^9, 
   3.7911004994401646`*^9}, {3.7911006691861944`*^9, 
   3.7911006732560973`*^9}, {3.7911007387078953`*^9, 3.7911007605713577`*^9}, 
   3.7911008258159018`*^9, {3.791130562502917*^9, 3.7911305654264016`*^9}, {
   3.791206779717471*^9, 3.7912067882934227`*^9}, {3.791206886689635*^9, 
   3.7912069198875313`*^9}, {3.7912069635058904`*^9, 3.791207137956523*^9}, {
   3.7912071740064135`*^9, 3.7912072356832037`*^9}, {3.791207305674878*^9, 
   3.7912073266311374`*^9}, {3.7912095339422607`*^9, 3.791209669160851*^9}, {
   3.7912097079191923`*^9, 3.791209764978924*^9}, {3.7912098169137893`*^9, 
   3.791209821155846*^9}, {3.79120988676807*^9, 3.791209887215577*^9}, {
   3.791210055646822*^9, 3.7912100766490993`*^9}, {3.7912101250334845`*^9, 
   3.7912101602162066`*^9}, {3.791210205081773*^9, 3.7912102491041346`*^9}, {
   3.791210281488631*^9, 3.7912103087433558`*^9}, {3.791210387556986*^9, 
   3.791210427098445*^9}, {3.7912104851834445`*^9, 3.7912105339448347`*^9}, {
   3.7912105692360926`*^9, 3.791210888207255*^9}, {3.791211001858008*^9, 
   3.7912110073777456`*^9}, 3.7912110779936914`*^9, {3.791341730267441*^9, 
   3.7913417419214973`*^9}, {3.7913417853146534`*^9, 3.791341798033826*^9}, {
   3.7913595355926447`*^9, 3.7913596023199396`*^9}, {3.791359651552575*^9, 
   3.7913597062433863`*^9}, {3.7913597434718823`*^9, 
   3.7913597740218496`*^9}, {3.7913598126023602`*^9, 3.791359862306981*^9}, {
   3.7913599027928705`*^9, 3.791359926202795*^9}, {3.7913599696895533`*^9, 
   3.791359969921548*^9}, {3.791528747219673*^9, 3.791528827929741*^9}, {
   3.7915288968390913`*^9, 3.7915289702003355`*^9}, {3.791531227788316*^9, 
   3.7915312723522496`*^9}, {3.791532430345541*^9, 3.7915324363043985`*^9}, 
   3.7917154946725683`*^9, {3.7917175987352476`*^9, 3.791717633265417*^9}, {
   3.7917176903000317`*^9, 3.7917179844329023`*^9}, {3.7917191493886623`*^9, 
   3.7917191998544416`*^9}, {3.791719317619587*^9, 3.7917193211025004`*^9}, {
   3.791719928883767*^9, 3.7917199393315153`*^9}, {3.7919921921122885`*^9, 
   3.791992229097124*^9}, {3.7919922611770067`*^9, 3.791992362232455*^9}, {
   3.791992435115878*^9, 3.7919924726572123`*^9}, {3.791992528339139*^9, 
   3.7919925772773113`*^9}, {3.791992607532773*^9, 3.7919926447634306`*^9}, {
   3.791992780587294*^9, 3.79199278333025*^9}, {3.791992817983365*^9, 
   3.791992820820018*^9}, {3.791992922305483*^9, 3.791992953133733*^9}, {
   3.791994009721076*^9, 3.79199410409595*^9}, {3.7919941363315954`*^9, 
   3.7919941627997417`*^9}, {3.7919942015815783`*^9, 3.791994455260667*^9}, {
   3.7919944855065684`*^9, 3.791994546856903*^9}, {3.7919946309580555`*^9, 
   3.79199474786643*^9}, {3.7920389254875913`*^9, 3.792039113892807*^9}, {
   3.79203916337255*^9, 3.7920393202505665`*^9}, {3.7920393786520815`*^9, 
   3.792039380118044*^9}, {3.7920394424354606`*^9, 3.7920394439304223`*^9}, {
   3.792039726241169*^9, 3.79203982138475*^9}, {3.792040046856691*^9, 
   3.792040134683462*^9}, {3.792040254077426*^9, 3.792040254485421*^9}, {
   3.7920403483660336`*^9, 3.792040398843749*^9}, {3.792040501513089*^9, 
   3.792040505391992*^9}, {3.792040595544704*^9, 3.7920406003075857`*^9}, {
   3.792040684915433*^9, 3.792040688527341*^9}, {3.792040743562943*^9, 
   3.792040784374906*^9}, {3.792040901209937*^9, 3.792040925334028*^9}, {
   3.7920410140407734`*^9, 3.792041086887925*^9}, {3.792041289902769*^9, 
   3.792041337551556*^9}, {3.7920415013043966`*^9, 3.7920415548520365`*^9}, {
   3.792044562153653*^9, 3.792044575676306*^9}, 3.7920446552282877`*^9, {
   3.792051770806929*^9, 3.7920518306450343`*^9}, {3.7920519059258633`*^9, 
   3.7920519060278563`*^9}, {3.792051942438936*^9, 3.792052010747198*^9}, {
   3.7920520651548185`*^9, 3.792052065432809*^9}, {3.7920525026306853`*^9, 
   3.7920525050786266`*^9}, {3.792055255809986*^9, 3.7920552984689035`*^9}, {
   3.7920554397570353`*^9, 3.792055479555025*^9}, {3.7920557794534273`*^9, 
   3.7920558144525375`*^9}, {3.79205585687946*^9, 3.7920559060342116`*^9}, {
   3.7920560429307375`*^9, 3.792056109535041*^9}, {3.7920562621481895`*^9, 
   3.7920562656591005`*^9}, {3.7920564039456854`*^9, 
   3.7920564056376414`*^9}, {3.792118984679653*^9, 3.792119700388457*^9}, {
   3.7921197304460335`*^9, 3.7921197307897825`*^9}, {3.7921198402518864`*^9, 
   3.792120081728806*^9}, {3.792120114836179*^9, 3.792120186233304*^9}, {
   3.7921202553796024`*^9, 3.7921202970602226`*^9}, {3.7921203559988394`*^9, 
   3.79212042214878*^9}, {3.792120658655156*^9, 3.7921206707893667`*^9}, {
   3.7921207272140646`*^9, 3.7921207310265503`*^9}, {3.792120788922217*^9, 
   3.792120829722706*^9}, {3.792120872221571*^9, 3.7921211053517847`*^9}, 
   3.7921215799024444`*^9, {3.7923266274066224`*^9, 3.7923272329749365`*^9}, {
   3.7923309596675897`*^9, 3.7923310965709906`*^9}, {3.792331141028582*^9, 
   3.7923311795014935`*^9}, {3.7923312166681995`*^9, 3.792331243202761*^9}, {
   3.792331320135166*^9, 3.792331406934375*^9}, {3.792331461517105*^9, 
   3.792331506682172*^9}, {3.7923315573977423`*^9, 3.7923317291698737`*^9}, {
   3.792331827565338*^9, 3.7923319951021404`*^9}, {3.7923320381848016`*^9, 
   3.7923320883003454`*^9}, {3.7923321396999564`*^9, 3.79233219860413*^9}, {
   3.792332333917158*^9, 3.792332398230942*^9}, {3.792332434284911*^9, 
   3.7923326364744573`*^9}, {3.7923339049838934`*^9, 
   3.7923339219704447`*^9}, {3.792333963113363*^9, 3.792334065357673*^9}, {
   3.7923397925372334`*^9, 3.7923399249628553`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N1 = ", Rational[-1, 
     4] (-1 + $CellContext`\[Eta]) (-1 + $CellContext`\[Xi]) (
    1 + $CellContext`\[Eta] + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288235507`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], "+", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["xT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     SuperscriptBox["y", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"y", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["yT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]]}]}],
  SequenceForm[
  "N1 = ", Rational[-1, 4] + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`x^2 + 
   Rational[-1, 2] $CellContext`a^(-2) $CellContext`x $CellContext`xT + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`xT^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`y + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`y + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`y + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`y + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`y + Rational[1, 4] $CellContext`b^(-2) $CellContext`y^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`yT + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`yT + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`yT + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`yT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`y $CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y $CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y $CellContext`yT + 
   Rational[1, 4] $CellContext`b^(-2) $CellContext`yT^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`yT^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`yT^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288235507`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]", "-", "\[Xi]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N2 = ", Rational[1, 4] (-1 + $CellContext`\[Eta]) (
    1 + $CellContext`\[Eta] - $CellContext`\[Xi]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339928839176*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], "+", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["xT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     SuperscriptBox["y", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"y", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["yT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]]}]}],
  SequenceForm[
  "N2 = ", Rational[-1, 4] + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`x^2 + 
   Rational[-1, 2] $CellContext`a^(-2) $CellContext`x $CellContext`xT + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`xT^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`y + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`y + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`y + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`y + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`y + Rational[1, 4] $CellContext`b^(-2) $CellContext`y^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`yT + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`yT + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`yT + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`yT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`y $CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y $CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y $CellContext`yT + 
   Rational[1, 4] $CellContext`b^(-2) $CellContext`yT^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`yT^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`yT^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339928839176*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N3 = ", Rational[1, 4] (1 + $CellContext`\[Eta]) (
    1 + $CellContext`\[Xi]) (-1 + $CellContext`\[Eta] + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288547993`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], "+", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["xT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     SuperscriptBox["y", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"y", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["yT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]]}]}],
  SequenceForm[
  "N3 = ", Rational[-1, 4] + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`x^2 + 
   Rational[-1, 2] $CellContext`a^(-2) $CellContext`x $CellContext`xT + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`xT^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`y + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`y + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`y + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`y + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`y + Rational[1, 4] $CellContext`b^(-2) $CellContext`y^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`yT + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`yT + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`yT + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`yT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`y $CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y $CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y $CellContext`yT + 
   Rational[1, 4] $CellContext`b^(-2) $CellContext`yT^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`yT^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`yT^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288547993`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N4 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[Eta]", "2"], "+", "\[Xi]", "+", 
      RowBox[{"\[Eta]", " ", "\[Xi]"}]}], ")"}]}]}],
  SequenceForm[
  "N4 = ", Rational[1, 4] (-1 + $CellContext`\[Xi]) (
    1 - $CellContext`\[Eta]^2 + $CellContext`\[Xi] + $CellContext`\[Eta] \
$CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288547993`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N4 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], "+", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["xT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", "y"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "y"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     SuperscriptBox["y", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", "yT"}], 
     RowBox[{"4", " ", "a", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "yT"}], 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"y", " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", "y", " ", "yT"}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     SuperscriptBox["yT", "2"], 
     RowBox[{"4", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]]}]}],
  SequenceForm[
  "N4 = ", Rational[-1, 4] + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`x^2 + 
   Rational[-1, 2] $CellContext`a^(-2) $CellContext`x $CellContext`xT + 
   Rational[1, 4] $CellContext`a^(-2) $CellContext`xT^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`y + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`y + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`y + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`y + 
   Rational[1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`y + Rational[1, 4] $CellContext`b^(-2) $CellContext`y^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`x \
$CellContext`yT + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`yT + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`xT \
$CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`yT + 
   Rational[-1, 
      4] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`yT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`y $CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y $CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y $CellContext`yT + 
   Rational[1, 4] $CellContext`b^(-2) $CellContext`yT^2 + 
   Rational[-1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`yT^2 + 
   Rational[1, 
      4] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`yT^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288704233`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N5 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Xi]", "2"]}], ")"}]}]}],
  SequenceForm[
  "N5 = ", Rational[
    1, 2] (-1 + $CellContext`\[Eta]) (-1 + $CellContext`\[Xi]^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288704233`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N5 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "-", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT"}], 
     SuperscriptBox["a", "2"]], "-", 
    FractionBox[
     SuperscriptBox["xT", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "-", 
    FractionBox["y", 
     RowBox[{"2", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "y"}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox["yT", 
     RowBox[{"2", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "yT"}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]]}]}],
  SequenceForm[
  "N5 = ", Rational[1, 2] + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`x^2 + $CellContext`a^(-2) \
$CellContext`x $CellContext`xT + 
   Rational[-1, 2] $CellContext`a^(-2) $CellContext`xT^2 + 
   Rational[-1, 2] $CellContext`b^(-1) $CellContext`y + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`y - $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`y + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`y + Rational[1, 2] $CellContext`b^(-1) $CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`yT + $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`yT + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`yT],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399288704233`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N6 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Eta]", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N6 = ", Rational[-1, 2] (-1 + $CellContext`\[Eta]^2) (
    1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339928886046*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N6 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "+", 
    FractionBox["x", 
     RowBox[{"2", " ", "a"}]], "-", 
    FractionBox["xT", 
     RowBox[{"2", " ", "a"}]], "-", 
    FractionBox[
     SuperscriptBox["y", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"y", " ", "yT"}], 
     SuperscriptBox["b", "2"]], "+", 
    FractionBox[
     RowBox[{"x", " ", "y", " ", "yT"}], 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", "y", " ", "yT"}], 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     SuperscriptBox["yT", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]]}]}],
  SequenceForm[
  "N6 = ", Rational[1, 2] + Rational[1, 2] $CellContext`a^(-1) $CellContext`x + 
   Rational[-1, 2] $CellContext`a^(-1) $CellContext`xT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`y^2 + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y^2 + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y^2 + $CellContext`b^(-2) $CellContext`y $CellContext`yT + \
$CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x $CellContext`y \
$CellContext`yT - $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y $CellContext`yT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`yT^2 + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`yT^2 + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`yT^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339928886046*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N7 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Xi]", "2"]}], ")"}]}]}],
  SequenceForm[
  "N7 = ", Rational[-1, 2] (
    1 + $CellContext`\[Eta]) (-1 + $CellContext`\[Xi]^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339928886046*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N7 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "-", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT"}], 
     SuperscriptBox["a", "2"]], "-", 
    FractionBox[
     SuperscriptBox["xT", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"]}]], "+", 
    FractionBox["y", 
     RowBox[{"2", " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "y"}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "y"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox["yT", 
     RowBox[{"2", " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]], "-", 
    FractionBox[
     RowBox[{"x", " ", "xT", " ", "yT"}], 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b"}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["xT", "2"], " ", "yT"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b"}]]}]}],
  SequenceForm[
  "N7 = ", Rational[1, 2] + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`x^2 + $CellContext`a^(-2) \
$CellContext`x $CellContext`xT + 
   Rational[-1, 2] $CellContext`a^(-2) $CellContext`xT^2 + 
   Rational[1, 2] $CellContext`b^(-1) $CellContext`y + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`y + $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`y + 
   Rational[-1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`y + Rational[-1, 2] $CellContext`b^(-1) $CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x^2 \
$CellContext`yT - $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`x \
$CellContext`xT $CellContext`yT + 
   Rational[1, 
      2] $CellContext`a^(-2) $CellContext`b^(-1) $CellContext`xT^2 \
$CellContext`yT],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339928886046*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N8 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Eta]", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N8 = ", Rational[
    1, 2] (-1 + $CellContext`\[Eta]^2) (-1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339928886046*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N8 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "2"], "-", 
    FractionBox["x", 
     RowBox[{"2", " ", "a"}]], "+", 
    FractionBox["xT", 
     RowBox[{"2", " ", "a"}]], "-", 
    FractionBox[
     SuperscriptBox["y", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"y", " ", "yT"}], 
     SuperscriptBox["b", "2"]], "-", 
    FractionBox[
     RowBox[{"x", " ", "y", " ", "yT"}], 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"xT", " ", "y", " ", "yT"}], 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     SuperscriptBox["yT", "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"]}]], "+", 
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]], "-", 
    FractionBox[
     RowBox[{"xT", " ", 
      SuperscriptBox["yT", "2"]}], 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"]}]]}]}],
  SequenceForm[
  "N8 = ", Rational[1, 2] + 
   Rational[-1, 2] $CellContext`a^(-1) $CellContext`x + 
   Rational[1, 2] $CellContext`a^(-1) $CellContext`xT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`y^2 + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`y^2 + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y^2 + $CellContext`b^(-2) $CellContext`y $CellContext`yT - \
$CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x $CellContext`y \
$CellContext`yT + $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`y $CellContext`yT + 
   Rational[-1, 2] $CellContext`b^(-2) $CellContext`yT^2 + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`x \
$CellContext`yT^2 + 
   Rational[-1, 
      2] $CellContext`a^(-1) $CellContext`b^(-2) $CellContext`xT \
$CellContext`yT^2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399289016695`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1,L = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N1,L = ", 
   Rational[1, 4] (-1 + $CellContext`\[Eta]) (-1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399289016695`*^9}}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nXmczfX3x5WlFRXJEiPZIkSWDM1btpIlLZYoRb6RJVKJZGlIZMm+jKUR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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJx1mnlUjmsXxjN05Bjj+JAoY4VC5undclBSdBDJGCKZqUxRmRWKjiFCisqQ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     "],
    VertexNormals->CompressedData["
1:eJys/XlUjf37/o+HzDJWNCglmWeJqAMZMhVJEkolc0VkHho0oozJnDSRUDSn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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.792339929026661*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1,L - \\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N5 = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}], " ", "\[Xi]"}]}],
  SequenceForm[
  "N1,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 = ", 
   Rational[-1, 
     4] (-1 + $CellContext`\[Eta]) (-1 + $CellContext`\[Xi]) $CellContext`\
\[Xi]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399290422835`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx9nXdcVcfz9xFLLLFjiRUL2HuLQlgl9oodVKyo2HvD2DDWWGNDBQVsICoI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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl
SLRaElIk+xrZ9+z79vd/P977PK7fvHPu3JnvzL3nvOc9t3pn9juhb5Fl2f4h
y6L+Hl9m2VL9/S7PsocrWXaCTi4R3lb2rYX3E14snAvPEP5cFz+mvo+r3SG8
jXAttcay76l2kNpH6v+VWhvO6foHdfyH+kxW/46lx9uo6x8SPlp9agvvLfuO
wodzX+E9hHcQflX4UuE5wv2ET9J4y4S31/lawk013gjh+RrvZuEesq8U3lX2
7YTbyH6P8OuyTxXuJvsK4V24r/BA/d1P+GSN30x4O/2trbaXzu+t9praQNnv
17mLZF+Zrv9d49XgeTT+Y8K/CC8Rvlz9DxDuqv77CB+n/ouEt9b5rYSPEV4o
vKXwFsIn6/on0njLhK/kHQr30PX7Ch8p+3zhD2WfI9xM+CbhB4VH8/5Kv99P
hOcJ76XxHxL+W9dPYXzhR4V31LjbMB5/hfeUvY7wKbI/Lryzzm8r3Cj6fr/K
frdwO53fkvcpvL3wNLU3dK831abr+Kn0vv8S3lz4WvU/VPgM9T9A+Fg93yPC
X8r+IPNLeLnwj8KLhJsL3yy8UPgW3k/p5/9c+AHhKzTegcLdNF5zxhPeXngf
4Z2EV+n+rwhvXvh73y17R+FLhY8VniJ8vPDlwh14fuEThK8S7ii8t66fKfw/
4SK9n02Emwifp2eZJNxBeIDwMbKvFe4rPBW78HThE4WvFj5O+CLhpsIdmEPC
8zT+JOFV+j2fa7wGwncKfyv7H6Xnu/5kjYTP0cEM4ZOEBwsfr+v7C+/DOhXe
W7gv81L4GOEmrCfh6sL7MT91fTuda6t7HabWXsfrZL9I9hmyny/8ZPrezNdq
wmeonafj89XO1PFo9eut47PUegifptZHx+eona7j8br+HF1/nfDi0vNthvA/
ui5P67mKcFPhC2RfLXy+8CR+H+9Xrb2uPVztKB3vmt7PD7L/pf67C98t/LPw
P6Xnn/7LdhM+W/hlgQHCs4UvTPNhM+Hmwn1lf0m4v/A93F/254QvEL5b+Fzh
OvgV1jrvlbXKffj+avVYL/xmfqtaF/wfTcf703Q8Ttccob4X6rrDmZ963t1Y
T7IP1v0P1rmDdXwITcc3qf9hsvdR/1bCV6t/Y+av7MPU/wi1+4U3CN/LehO+
V/gt4ZnCdZnn+AKN00Kttc4dKltrtTY6ri9bvcL+/AC16zR+a11/rOy3aqxD
de4L1p9aax231bnZmdcwa3m0zrUXPk9jtBW+TNc3xP/KfqX6Ppy+7yvCPwv/
VDoGfFEYv6LrL5H9Pt6/ri/UfzjjC38o+yzZTxYeKnyC7LOFTxG+Xvgk4ZnC
nYWvEe4kfI9wF+FrhU8UzjXeMPy38Aca7xLZ9xU+Ubip7A+k+bJGz/e17OfJ
vqPw0bLfwPpSmyO8XvZ76C/7qcIjZD9FeIGunyK8Vvbv1Hcn4fHEL9l/Fe6l
vwfKdhBN/S+VfRf8ofBA2fdWu1F4nvBI2Ssa/10dv6c2u+L1zvf8RuNMFO7O
mhAOwiuF3432Z7XVvxHxS/Y1wlH2p4R7Cr8gXFV4jfCZwi8KVxdeS3zU9ZsL
/4kPF56R3tccjfea+nZTe5b4rf4rZO8qvEo4E36C9S+8TrCa8PPEA+FnWA+6
/rGKYyqx9QG1UTqerPEHyT5ZeI36vkr8YuzC93tCv/8s2ccL91L/H4QvE14p
/Ibsp6utFa4ivFr2DRqvjvBOGm9P4Xei+cCWwrsL1+abCg8Tvlj4Yo1XX/g4
XX+TbNuV9i/DZe8v+w6l1/uNwpdWfA7bDWoDdHyHrm8pe3/4iPoOEG4gfILw
SL43PkS4pvA69R+g59kZ38D9ZftE55fpeLnaeNlP1bnnZK/o/DPCb0XH12qy
78rzRs9Hfh/++TS154U3Uf9Vsv8RHP9WCw8jtkbzn4r6NxB+LTr+ZsL1U3/e
/xr1X6+xOghXE94XfiT8vvrXTc9LfGifeN7usveR/UKBWml84s1fso8Wfl72
4er/uex7CbeQvYXwI+pzh2wT1Bbp+DbZ+7A+c+OvouPdAcIHqv/TGq+r8ET1
XyL768HxYj7zWfgf4VuE17E+K9l/D3cr/kV4hPAX0fENn4vvhX9xv3msl9L+
4Dbh1/j+sl8gvFV6P8SHtuG/qZ011P/OEv5XeJzwy8I3st6ErxJeIHyJ8BHC
PEZj4oP6/xLNN4hRxKrvhFtkyecKfx0dj1sKtxT+LY23Ste/res3yt48cwwg
Fhwl+6bCexF/Ze8n+3ZpfhMfv432Z62ED1X/X6P53xHCR7N+ovlpG2K68I/C
+2eO8cT6vsLbpvkGX4GfnC48DZ4ufIxwVeFmxEvhi9R/h+RviJe/CR8ifFRu
fvNzNH9tJ3xEip/4y8m6frn6b1N6fQ/Jzcfhq8SzU2UfI9vWrCHhQbnj8+HR
/La6+t0vXEV/35ftA7X7hDctzZ/gGHCNA0t/3yeEJwgP1fUHCx8JP5TtWuFW
6XnHClcpzZfOFe7J88r+tPA/wo8Kb1Ka750tfCr+M/j9t9PzDiHWCh+N/xCe
LXylrt9duIn6XyNctXR8giPBlWqUjl/9hPsIVy8dry6EMwlXKx3vLhDuLVxT
43+q48/U5gtfpfEbyd5U+Fr1PaD0/HxU+HbZD2K9CT8pfKfw/qXXy1Lh24Rb
lF6vi4THCZ8YHU9q6z4LE58i3n2v3zOpYj4Fv/hJ+C7hrfR3S7Xd1X8PtSYa
7zrZ7829/j5V/z3S88G3yQeJH9sE52udo/3dDsKPpHh+FP5ZY95TOt8hfmwV
zPfJ14hn2wXnl12i/f9OwouFO0XHo1rCCyrOR4h3dYPzKfIX/GWd4HyhfjR/
+brw+6lGvqln/VhtLu9bz9Bd9otz8034Mv77WPyLbPVK88Oxsl8le8PS+eV4
4SEV5xt8n+7qPxq+Xprf3MZ8gB8Fz49TZB8lW/3SfHSc7FdXPAZj3a42lO9R
On+8g+8tvJvwFcJ3Cl8Hn9B4uwp31ng3y7Zj6fxipOyXJf9CvveM7NfDB0vz
+dGyXyH8S3D++1Th8YZExzf8B+vxKnJw4dMKr5+zg9f/EfTHn6ody/pV/87w
t9L5DhwYLkx+QXxuof51hbsFx49Wwpfz26Lj5248r3AsnX/1FO4KHyqdf/US
7i58WrC/aqPrr5bt8ujf34jvwfyRvQb+VX9fVP+/ovnzCbnzq3+i+Wrn3Hxx
UPTvay48nLUXHA9a4t9LfxO+za1qg3S8MXi+Pyb7YOFLovlEA/iB+o+J9p8D
hecRP6L5/im5+ShrnLXel3hTsZ4AH6sfnL+T7/QQvgueoOvnq12We8yFrKHS
vhEfuZw1gs/BtwgvFh6j664QvhzOBVfQudNkm6Lzj5Z+Jp7tUrX74YZq05mb
6vOJ+s5hvub22XBdYgBziTlFbHi4tO/Gh8PVyOHI5YixTwkvFb4+d8x+JrgR
04nl2IgBcCs4FrFhHN+Rb6e2oDQngBsMzc0d1vIb1HZSW8w7UZsp2wy1F+Gi
anfljqHE5u7R/KuBjpdXnGORx44Nzr04JrclRnHuosJ55Hgd386zll5brLF3
gu85TXhq7meBg0zIzUnhJnBYuOzdaqtLP9M6tZ1LP+tL+juL36P+X6j/K6V9
JXOIuTSz8FpkTZJrPyf7lNwc7YNgzsLaxwfAZdAkjsmtkaBVwJnh6vfl5tK/
qb2WW5Ooq3exEX6ZO8fZIjoHIjYSI+FCPwZzbLj1m6U5CNoQPgPfAUdEW4Fj
wh2/EH42d85dnblbOLYQY+Bm5FDkUqvVviqtWaBdPEMMK+3jiX3EQHz/vaV9
LT53nvDb8Dzhlfhk2T4qHcuIaZvofp8IP51bA6kSnSOuyJ1zkTsSgy/KzSGJ
zWsLxzpiHlwVTYBcmZhGbPtR+CXhacSYmHJS4Zdz56q/qL2aO4fdMVpzIbcm
JyM34x2T8/2a3v33rKncOWGt6Hd6f+6clnf9qZ7nReF1aj+U1oy+yK3poSX9
VlirQ0NDS/uzsDaHRocWisZBLkqMJlaHirUxNLJ9ozUUtC80MLQVclJy0+fV
vi3NGeGO5EhoLcx9tBQ4I2sATQBtAM44KjhHJpdvmDl3RpPaRbheZq0KTYlc
lpwWrQlNcNPcGhhaGD5/+9waE7EAjRStA80D7RQNbuvcGgxaTGPhOrljxjms
V/3+PXSuN3mh2pYV655PwxPUjsS/RvOkmhW3P3JrrNjQgIvcGhlaGRpxjdwa
E7+fsbfJnUNzj3bEi2heUL1iTQdthxzqJJ3bRTjmzrFOCeagH6Tv1Saag3yd
W6OGm8Cpvs2tkcO1yOnfS/PvkGiN9ZU0v/hemwfzvKN0fDS5ROFn4N6dk+2z
9H3pUzU9A/dui5ak483T9+0pW0Phqrlzyh7BGtaA5N/xv2iQA1N8wb/DgT5O
8619NOfmHMdwcTQe5ghzY3R6R7/m1gR5dwfDH6J1jCoV+3d0v2XB8YpjtEA4
N+fQDNEO4byPB+f8nOOY+EKM7Jv8xcpgTfOk3DF8Rop36IyLguMfmmyn3DEf
rRbNDB1tRLCWhqaMDjc0WGvmGG2OHJRzaDRoNeRow4R7Fz7H8fBgDbij7G0y
a8OMjVZHDsY9Wuu3Hxqdp2xWsWbVJTcHQMtCE0QbhOPMD66RoK3AkeHKaOR/
Z9Ys0S7R/NFS4MTHpTn/lI7/zr0WuMdPuTV67k1NAm0HTgG3QCPrlptj42+p
eaANwanh1mj2aENwZrgz7xLtlpyHd9qN75Gbgz0UrHnxG3h2+AE1BrRIcjhy
OWoWe+fOAahlUDNAq4CDw8XJGWun9cZ6RxNBa0BzODE4B62W5iv+A00MbQyO
GqM5NFwazv1NMEdGO0JDgjvDke9I8Zm4do+umaX2k45/DtagiDFvFdam4LzE
+yszc2HiBXxoCO84OKchXl+fZf9pDWgqaB9wWLgsmgraAZwR7kgNgVrCy5lr
SXBOuGe7zFo/8RI+cK3w/4JrMMTbkcJVozU4tLgt1I4PzlGIfxMy5y7EB+LL
VOHG0TkruSs55qNpvaC1oLnANckhySXJMVcE55z9UnyEl8Gp4dadhB9O65M1
O7ZwPk38IT5Ol71JdA5MLkzOvSQ45yT3RIPZProGA18YJVxDeLHaIn6XWr3o
nJN4PAafGp2Twh/GCm8TnbM/keI5cTUG+89viCkVc2i49JGZtd6GwVobnA/u
R02C2gQ1NfwhGhRaFJrQoGCNEC0NTe28FP/ggP0K6zVoFmgXaDi3Bmso5ELk
RGh/12jMwWoX6PhCfIqOR6jdqeOJwRos85sciVwJDY35vXPmXPKkwrnKrplz
t06Fcx9yILTELoW1A3JEckVyaHJpckpyy46Fcw1yDrRMNE7iOZoE2sQVsh8n
3FZ4qvDAwlp+a+HJwRoQWhAa0BjhTeB/wt/n9tdVK66tUWNrleLLz7l9DL6G
miW1RjSZw1O8+jN3zCX28o0qxIvS3w5NCK0FzYVa2KYV14qJhwdF+zB82Ur8
QbQGiBbYTPi6YI0MrQxN7IZgjQutC01tZLBGir8gJyQ3ZAxqpHAExqamSG3x
yczxlJyP3O/wLNUOKs5dyVnnBOec5J7HCT8YrKHjL0u1p/HdGuP1zNrH4xVr
3Pjnf3PjnrK/IXujYH28l/DbmWvBXH+W8PrMtaNnWZ/C7wg3DdZ/VyV/uWlh
+9rkz2uw7ivW8PHXm6k9p+M+uv69zLUd8NnC7wo3D9bHzxHeILxfsD5/rvD7
mWs9jHceOYHwgcF69aTS64t4Rb50puxvsfaD6w0rUrwq1J6sOOdulPjhqeqz
hc5v1PFnarsFa9Y7JT4H/0NjxV9umeIbGnIl8Sn4GXwHfllfrb9sZ8ChM+8N
4H7UyOCPjdUGldYMdkv8s2uw5tYk8cszhOvq+Gsdf5JZE2hQ2L9S83g2ugYD
f21ITCmdwzdI/Ba+RQ0L/ru72hWlfQXxtKvaXeSKpecTfAQ+dEdpfw//gG+g
YZKv985ceywr3rsAP2RvBOud9QjfHpj8Q6vEJ+DbaDD4n4NSfEUzJf8+O/Pe
BjSZI5N/Qqshn0QPOFP4xWCNh/zyYuFPgzUrtCs0py95Xj3D7WhozMfgmgf5
+YWyvxesIZH/9xP+MLiGQi2FmsmbwRoZ+RuaBdoFmirrHU14SHANEf9Dvnpt
8nctE7/qn/xVr8Qv4FMTgv0stZUppfkXfKuD2m3pXI/cmit97xbunvjN7cnf
9Uz8ivx4fGl/CF+Dv5FPwE/2Uhsq2/nBcYBa342l/Sv+Bz5IfoPG2jTxGfIP
9qCQv03LnI8xBjrw+uix0ZCaJz50bvCY++bWmLgXNVv4UjM4Rek9EuRn5Ivk
e6/r3NzcNbjvg/fMsE+iRfR8ISd9OcXjHaIbcZeaKrZto+ModaYfUk5Kbroo
xeIFwX5tbmn9B40IrainxnskuM+szBoC1zLGusQ3GPv30rXf2YmP/IlmIHyf
cEPhraLj+jel883/ldbr5+Ezdf7v0vXNufgH4X9L668PJD5DMQW9e0HiGzwT
vIR9BQ+kMcllJ2e+V1T/r3Lvkdkn+l2xt4T8nHeGpnRVWg9LNc5C4cFpPT4W
rNmg3VwtvCG4Me+fLW1Dgxqa1tuTwRoQWtBg4Y/w2cITc/PHt4L1H7SpIfjA
4Ma6W5e0oZfRQHLzv690flZpPbBL4jMzS9cKOqf4dJ9w/7S+5gpPLa2tdkjx
lPXAWoGD3JTaMZnXCLZp+NAUz4j/fHO0PzRB5sKM0rUT+Bz8dHrp/RudEn/g
N7Lu0eD47e+oLcjNV3/X+XeFH87N9/4M1lzxs/jb1dH1FGLB52rP6/h85kbm
PQVrozV5+Ab5C/kBMZJYuVeKvcsS31iROZ8hJhI72X9BrCTGVUn5C7GPmh37
MeDP1PL6Rz/Lp2promuYITdfb59iILGQ/Q/EWmJktZQ/ETuJqcRW9k8Qe4mR
NRO/J3YuSXyT/Jf86TD1+zjzHjbiS6vgfOCV9Hs3lK7/wnfh//DXvxL/+W/v
WcW1ffIzYu/7pffLwa/JP94TXpybP5OfoLGhtd0lXDNaA0QLJF/5Nlh/Qtsj
ByIXeqt0PZ58inyHczdk1qjoyxjw9i9Lj71ZdF7yaWn9joaWNzGzDc5SSfkd
XIYYTaxmPx9cAU4EV6JeBFeCE2Up34Ursafu9eRPmkXX3Ki9ke/2Lq0BogWS
/5TRMZfYC/+/LXjPy4bkX8i70ZjRmolpxDY09OEpXhGfWAOtdXxZ4bVxs/p0
y6wZoh2Oil5rxDS0SdYk97qu8Fq9PppbE1OILcOicztiPrF/ZHRuRY6F1ska
hmsOKby2WWP0H1R47bHGGO/KwmtvWfRv4TehVeJTedffFfa1+FzexcbCvnhJ
tO9Fk0SbZK0SqxcVXrPDo+8PR4Gr4NuI7QsL+7gp0b4MzRnteWm0b0ZjRGvE
x8DdLynse26Ifh9wRLgisQTfMrJwTLkz+v5wBmoHd0X7RnJstPUJ0feHY1AL
GBfti+FI1DZujfa1cBxqDWOjfTechlrHJOHLM2vwaPEvBMeu6br/4/jyaF9O
TYDawIpo34KPIbcZHe37qHFQ67gl+npqLNRa4EzcbxaaQmnOxvPdK7wCjhDN
PeAccI+J0VoDmgNaPZyM558LPy49B8/NXBNhbj4Src2jKaMtL4yO5eTYaNGs
NXzr+sJr7v70/dG80b7npu+PJoA2Pgf+llkDRwu/N9oXk4Oj3U+LjjVoDtQi
8NF87+cK++77onNtcm5qA/gUYtcLhX0NPgdf8mphX0QNaUTih9SW+I3UK9Fj
+O28o3GJX/Lu+CY3J/7It+Kdjkl89MUUGzleWjhG4hN53pcK+8qu0fuL6un8
Un2/h6K5CBoIWvv09HxoNNRWiEl8/2cLx6onovf7knOSez4evT8ZDg4Xfyya
O6Cho6Xvn9ZTCM5j4SxwjV8Kcxk4C772x8JcZmr0+0Izopb2qPDDmTV9tP3l
0do+mjzafOP0/L8X5j7z03jUVKitzE7fH02IWgw+mvXzdGHfXSN93w2FffSD
6fmo8VDrmRlda4BDwiWbpPn1l/rDreBmxI4PC3M09rStT3ysZYpX7Pn7IMU3
9gTtkFvPYK8Qe5bYu8Seg9rR+T7aDO/0gOia15U693lwvQu9pElmDgwXpoZK
LZWa+NfB1/DOK0k7QM+j9k2967vgPeLsFadeVYe1Lzwqd73s4+AaLGMyFvW0
7sG6HLVl8jX2zFFPol5EvYZ6HmNwLfVO9FRqCR3UOkY/+y25a/z8BsYg92uQ
eexewToLnB/uT019Uu76I/WyW4WX5K6HbR2do5KrovecHtzQKahdYxvDnM5d
X6um/gOFb8pdb30/eM8Be5nQr9CP2PNE/XNo5nobe5DYl7Y+uP7ZKVg3ZF8q
+TN70thLhH6CvsQeptm564/sbeJa9rZRj2UM9iSwNwh9CP2JPQXsXUJvQa9i
jxn1TuqT1APZ48BeJ/Qy9KkJwifmjnE3B++xoj45LHO9kT3E1KfPyFzvRI9l
byD1xk2j99xSD+6VeS8ue/TYP4kehN7FHtFrctef2TvKHm/WFmsM3Yc99tSP
qUdTL0Xr5R6MTb2QPe7U08gvqBuxZ436LvVv6oPMUXJBND7m7lGla0HUQKiF
3C58fO6YfWPijzWS/oi2wp4W9DT0s86Jz6IdsecFLWiirj85d0y+JXhPC74J
H4Uezx596n/kQ9Sh8Hm/5dbb8IVjhR/JXc/cPFqzQLtAD+wSrG/wbyhY7m0T
Hz84WO9kb8Qs4Xdy1w8PjNboOMcxehx6IDUqalPof+w5q5lbX2MvGnuAqO9S
T6Z+Ch9Hq2JPDtoWe8Rq5dYj2TvGHmS4CT6VdQ6fRrvCp6NdMUfRenbOPHfH
CR+dm3MMDt7jg/6Intsl8Uu0J/YsoQ2RQ5NLo4/2Cd4zhC/Hp1MvgX+iza3K
rN09lPQX/BX1FvbsVcmt57OXjzWNNoD+ylqHjx4SnMOQy3APdF32vnBv3jm6
P3tF+BZoFGgVrYn5wQ0dk33A2NhTRT2c+jn1W+rB+FR8KfVnNNjv03yglsYe
BvTVJzPr2/8HLJVvSw==
           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJyFmnlYTl0XxotShmR6yxSVZCpFIYlVSkgS8opEqJAIRYleIRqUNBlSqTQn
zZMGjZrn0kyoJEOhTBXfs7LO472e7/qur3/29Zz2OfsMe6/12/e9xA6YbTPi
5uLiqhjFxXVn+O8NbJ7Dv330p3ZYoiY2OSC7DW58K4rPntAEordCtNyca0C6
MOb9/vcl0JyZqavilwNhEh/SL+5Mgo1jDg1c3BkCCd9N/UYWu8AhY+PqU0qw
hov+CpblxHCxjo+6PibXltWvhWv9S1vWeaYOapdcvr2GlLv+1dNCXoFpisfd
m3bPodjD9rWqdwM4F/E5rnKphsPx27gGHhWDtUPxnclCf8atUd2/cmxvKAyJ
n9pUstwTBNxFvno5nIXXsqPnebJaxaYDPUWs47L2OsJjWP3kFTs+4rirLXtM
Lu7shDlTVm5buPslWHS1T3h7pRVGyKyY8WROPXwdOJzb4VIF/n59kzwdikBo
29OmDpds9rj7bfQsPR3CQaQoqsDT4Q5YD6wc8nRwBL4lOK4j2N8xvOrBOq5v
63fUg9XvmvllbjxvvLH39tNJ7eDiXFWlOP4FWE1dfhXsm0Gp+L3Whqg6OLi4
eMj1eiU0Od6cK/13IcTPeDkjhffPuB1JOxJFxCJhs9kb1b1NfvD65qkLZpIe
kNWuLoJtra6xiD7ruNPZrsczWf1ePhCbiOc911mndOSvV9AzujYQ3+/FDfYD
Hg6NcMYo6FLx8lrwyf77hMWsCphyWkHhyZwC0O54v8fJJos9rkXvls8hqQ8g
2WlS22ShQBCV3WCLz80z/Lx3YMI4+d14POHU0inYb2XnY1E8L061V0Lf4gUU
/OAJTH7XAo5WDSe6HOshmksvSTOrGk5JTusonF0GWgZNGvs+5kOT/udVqd2P
2eMOLdBYIrvtIRTqy/p9ywyCnUUiF1O774GaTYkstklvE+bi8edHzx+WYfW7
MXuvLJ7Ha7R8RmDIc/B+uyygQacJboQt6FS6Vgdv7k7sLt9YBRuuNe8SESsB
+03n9b9l5oHwxzGZ+k2Z7HGdDqqZpXZHQ5Os1p7WQ6GwPva7spnkfcgbfs/3
YW/Jso8trONjjJ6kp7D6dekOAp4Xttb5naNhC5i1GPt/T6+HWw3Werhu1I7f
WBUYUgGze33LT4oXQc7yWSfcnHNB205ceURxxp9xte79HZAdA70jTafnTIiA
lzaG2biuusbMD8SWNzIpPZt1fIaMAz/2A3fvLXjeJtGXGSfFG0Gt7Na96XPr
4B5/aSXO38SgocCQ1FLo1zFQxe86IJZ1aeHuHHASVswJSU1nj6t11Ke/wyUW
eOodG/D7ndeoUMH5PW74+4ZDlNMKBzwesygqDvvdLFHYh+d9GFrhuqutDqZl
FvrhOtU8qeiM82hhs8mYyNIiKEsVT5k+Nx+WCRzwyp2XDXkRW9U2haexx53i
cMdz4e44+Csi9Oa1A9Ewdfi+HoDUzu5IbLeZpGzH4+rzq/dgv/c89cfxPLdm
FwMVv2poHZ4vFbCnquUMfk/fiQ0no58/gfuzOqTMJHPheS+fNs6nodVHnvTc
fsQetzHoppyZZDx4ZR5YmMIbCzGvgtbi9948PK+iYTDIRxCPN0t8HYX91Nac
/gfPO3yq4OC2lHKwhx2KGI+OLLmwH9+r4IZ1jfGfcsH6cmgAPue2gk2n317J
AIUq2w2eDqnsce9le1THf4qH2WEnHfF55jXYv8D3mbwV40ssVE7RP43HT4nN
jMV+PpaTr+N5UdLmo8TlC2GJWLLC6mv5YOUmponPd+mfOGWMD/6VNVKy2zKh
wNfVW0QsDSwMbxcrWKWwxzV8duPkt8wECHOz7fJ5GA8WazLE8LkKh+dzPATZ
iTTjcf5ZKnrY73NMrC+e97lrVvjH6GxoHjFtxQW9LBj3yv4YjtN9BLTPLkmH
zd66Qo06j0DRoubxlvQUiPoardl6KJk97oIBlwmrryXC0nOu6wVHJkJO0Kf9
eP1Gy+R92Fr1tSrjcd/pxrzYT6N7S9RwvNngdesSqx1X1G+C7cL7pWuxrXw6
bTa2gwdbf2G/hxrCHdh2ORWUD68/GveD8LVobNMN/UKwnTAW108SdI/53WrS
cTnqFzCH4s0qjYxl5zth5MQel8lFXbBK8O6Kkosx4CAi1I154y9FlbUK0ukg
5fKmL645HTK3aE2TEU2CldVRiXj+9WvnTr9b/hqynFfdtdKIAdeMJFu83y+j
Zg//P2iEkE8JdxeYzG7zcFWJh44Fgx3mx1IhpcjgpcRG1jrckefx95I3wBUg
lLFULh7ktUc44/maXqNS8fym1TsKHA27YKnr4k68n0oTeOJ9JxXENiwc/v9G
LymBt0IdoLY4bbWb8ytYSnl8RezIrZjnjlF+tZv/qVHFuQWiNFqs9nU1Qe6l
ye6x7fUwh/K8wMCIwrdeT8GV8q8LKM7H+BUa5qYnIVsOf+WPSeeuKYTnxAEn
f1Q46DYWgA3l5z1rzcdf0kqDmbPOtad8fgQXemRsVPziQJs4Iet+4x7dl3HQ
SPnbMnqy/Yia2+Cp9jJqpZkvRDW8SR/Rchnk5eRqkCP4CgoE5i9zhemU31l8
sfxrtcQa75BH2ZjnLcqfnuZqMYdHxBlZAT3cKYNXQJ7yv/ir7Bu2BgFQWlM4
rmb7ffD1GhIUWxQFTouqYvY0PQSpZSXRPg9fwSJ5TcPceS/gNPFArekTYRu1
Rthp/mlo7vo6+EFc8Hjim+sYV0tlvHZgvJlGfNDw/dIjjDMjdS8r4bo6TJzQ
ZKprksIbABFN26Il13uBLfFCbdHx49gu/HC2PZnXDWyJGyzzKhzmrg8Ghc3Z
GzC/CNQd2aal/hIUjy/oSel+DtbEDYPXY5K8/evB/+0LOYNvNWBI/FBnrZwz
X7UE5hrtFh/VmQ9JxBFedU43JNc8ArVx0jOvmsRDN/HEkeTHQ/hemqqyd6Z+
9oZu4gpRUa412B4bO1gwWeAWlBFfiCc+5bFSDAXzZN1eR5sY6LHg7//V2gai
Fo/+wvd2mfhCMtZ7R8pgHbw9WHXEO7wa/Ikzel7d6o9g5Qdb79k9e97lwXbi
DZ1Yd2P9V6lwNevpAMYja+KO79zz3HoCgsHWcCqXpLY/SBB/GDYXqmGbMP+f
SLMpviBAHFIW3GpbLB0OGoXa6cmsOB68QEvm4NtnwGe9SUlErBmciEO0auz6
6nRrQb4l617t7io4TTzCv7lnPvJXc0V7Gsb1VuKSCS7eShjPCyxsmzE+cy38
zScOmtclcB7/1bZFB/mA4RTfm26bsB0Qty3ocAmABOIVy5vtg8hnoo0bHDDu
mxy5ZvFkegu8u9ByYEt6A5tXLPuPe3xOqIYLOjF148dVgiZxi2iS+h6cd8t4
IxzGfM+B6cQvlYcDJ5VIpwL/goVpxcsTwIU4RvhWf7LkmgiI1LMPSxkMho3E
M73zpRdg679EJdXDLQj2ENeI2r+1MpsSBV/fKOtMFooDqfDC1AUajVB95Zjj
xZ1P4TZxjb/wrqUTJ1bBjTsg7G5dBuLENwqz/VyXHMmHG4pmO/b/ygYd4hxn
tYgu7poU0Git8X5hnQDXiHciXuzZtNb5AaytzxzkrgmDV8Q9blfdHmCrrjwi
UsUrFHiIf0otP/Vl80VD+Q8FUYwrvV28v5zPPoWUaz+j4z/VsPnnhvnVQP2m
chB3mnV5VGsxfCMO2urQn4Pf9a2ZvDiuCxfioU2icZmYN53dbKwxP2kTFylK
5T3TZ8WJ+m1ftDeFR4IN8dGS9n4ZbLu1cn16bkdABHHSqoTzCk6sdRE8dsm7
46w4kDhfVa03rAZ83Vyf4n1tJk56mby77bZ7CaRYD32whkKoIF4y+aj5Zdn5
HFgX/P3D+HFZkE/cxD+Y6mkmkgJl6+btxrwpRPxkmPZXqpJnDBwrlw72vPAQ
phNHVarsjsfWRd/uuq9PFGgTT92Qsj0jZxkL52cuSMF1du6wreP2hkrgl1H5
IbOtnM1T8oOLZ9VqFILm0ZbdPQH5EExcdWl30AJ8b8qJNpYlEpnAteY3Xz2p
zzYJyUkGwR+VKyXXJ0ITcVaUQdEljbRYGBEcN/ghIgbiiLeO3ctcju3UJPGs
udoxbO7qCLqc0HIiDrZJi9nhPLbRPud7TLAUahUPrsf9mAlxl53yyD2CI/Ph
uV7ak4M8uXCO+Eve/muqxazH8HU2/0TkFEXiMLv4ImXkE+2H1tOQN/yJx/p4
bTQxH5UeKA/B+c5wmf0/E1uH1+fqkamDVX/4bJWI/acrrPi5YM00bZwnvJX9
8+SPPwE/9SueuJ9g+KzOrv6ORlo2mGt6L20wzoJA4jSjXSGieF8PnNwjMB4z
vKbiWiU0RSAZ3A5IfN9ekcjmNqVIWSHj0QlwS7RbW+FiPJwmftsZlTsL2/S8
V7E12/9w3A0vJ1kZwwTg2jJxJn4Hly0n4n6UZkF1kFYuxjEB4jhN953RY1+n
wzjrT0p33NNgC/HcrUU77G3UUmF//0y1Wo0UeEhc98uk8Z1GHGvfLVTeYDL5
D9/Zabc/N5dNhAPPeAf2vEtgc968ltMG2I7XzIuIqPvDe50C14836CdC/b7R
XficAqZnziLnHE131/83732YzrUIW3m9mCn/5r7CoZEfsBU2CG39N/9lqL/I
Gd5XlFim/JsDS/tvhWMr7SMW/G8e/Eo8aFATdP/fXLhqOO6w2tiJZlJOHXB3
rF+IxYpXYEb8xHVDKPS2ezO4ezz74elaz+akMfYDjhhv+uPGz/MNLvwvHuLk
HifzVTLP9vpA7RqrjBMiDmy+2dzkm5XCexKaxBvfJH+2BlnimNWOG2a1nAiE
TkX3ZP+V7XD9emeqAO9LNq/Mj+NST/rQCC1jy2UrlJ/CAPGKRO+2jOcHy0C7
q+bz58gCNq8wfMbJK9t5eCOdbPzBQ2gR36Y0NzavRB1sOya5/gr0lfSmebB+
2xCvvDm7xXuxYRBMD1VMQ54qbJLdva3qJVycKFMWUt0G54lXtGu722s0GmCu
XYbx6E+1YES8orgrohd1pQiRO1kacU8gmXiF4SlOXunSMl0TUhIIyQLe0a2H
brF1kMnvU1ansDhK9bJ1dnCJOxQTr3ia/C2EeaSgcOF25KkI64rBkUdeQNf8
nqwLyiweJl45+6X28seQp2A2+MBH9X4NBBKv6ORwS7SfKQae7XtdAlLy2bzC
8BQnr1jcqanKnhYM3TyjdU+wuITRSzaHXVTD+7X3HwziZvEuwytr9PTdazTC
YNVpl37kKefpx+8lcrVBxWLb17HNLWxeCZz6WFxwZB08svCpttGpBkviFdNF
u3YacxXBPoc5uzH+MLzC8BQnr/C0KxqhrsH/c5XtRRYXM7zidFBj04hiXyjL
+McB31sc8UrXJsPxyA+Trl7JRp5qtZhmVy7bConyE8e3n2kCN+KVEsXwbKl9
NTDy/TX+FF5WniNesfOMcepyLIBHGV2SW/Jz2bzC8BQnr3guDvz2LTEc/M6a
1xYvD2LrL0auo8PxfTkc40rCdcDwiqfSUSerJQ+g66aNC8brwIS/i5YYNIG3
YqC80KQGNq983uNhoJFWBT7FX863H6tgrYvfvOI7xJdpMvkJTP4c9Tm4JIfN
KwxPcfLK3LOjnafwPICl/RHzpwiEsnUavvfHpCRZ3C59PjvUySIYRhCvrJY+
NapE4iE8Dj29C/OLUZ/HeC9W3LBVltND3Y/hlRkXbH4dEq4E6bS6Lt3KUjav
JBrv+/jOJw/M5ptnDVb94RWGpzh5JTH3xGz8zsUnXp7XfxXO1nPCNKqjFazC
oNrp0h1sGV7pu66UPX5cDNxMOTYXeWqBfNX2b5m1YKied9F6Qw1sIV5xWluh
NPZ1KWRFJuiULS2GSuKVsookCcx3xfoKLtsbsqCAeIXhKU5eEeczbcR8b/Bu
WhWOz+g+68OWyyFfWd5RvdZ5LpLNKxv5lH/hvDMtMvqIPNVjPv6O3ocq2KS5
I+zBq0rQJ15punrfWv1eEezw8chS8SqAEOKVToXxuqhjaEgOxOtkPGbzCsNT
nLxy9MHs+8hHfYe2zu11jWbrQx28d5OQA6eH8dggZw0Qr9y7oLp6/69YUG3S
z8A4cOjQrXSbVeVwIKjUN2OoFEyJV6SG89ITeON8Sirpax6cJ175FWB0zXxl
Fvy6cWUzzrtVxCsMT3HySvzWGlP8Tk9O5qXPlItl80pO7K+ZeD/7mg+swHla
Qbzy+av6uTHf42D62x2OuM56OieuV/MuBOmYD91i8oVgTbxyXlDzS7ogq7XZ
eht1wmDiFWkhaxvUsxIGBF9HP02D08QrDE9x8srAl6vLt+SzOESmzRjvk9Gb
3Nti9+LvmAOqslaqcWxe2XhCIxWfq3dg8w4839LYuQr3Nd/SJihcNckFQeIV
71Dlw72uj0G0xYB/zdnHoE28sq9rfjt+TxNjb1uMd9HEKwxPcfKKqo8ilz6L
U/a8H5iAXMXwygFBQ398PyO75yzA+7ckXrnXtfkrck3hOHUxnCfpR2x+aK96
BPauRmPqVDJAinhFSfbNK2OuVFifMasN88JP4pUbj+o1+iKTQbRKYvrY3mQ2
rzA8xckr11Q+FOH9SkYKpzlZJIIg8crSNUIv8T3rnOQRx/vYRLzSZ7B12ajO
RDj27Nmdqm8d8P72vGvtFlEw9LZ766ShKNCo6dS2jskAfY/ISY4fEqFDSeDL
vaVJ4LwmMB7Pn5P568im053QXXhsKHNKO0heH+vkdrkLnv/sbD8k3AbjDD7Y
ThVuhMwUJVHdl9UQIXhqC663u95PFlup/vFjtJsFrDGv9CrvtWw94Q5Z+Vxf
Ulkc4yI6ajryjMi6A5NaWMfF5d20MW7bH68JRa5ifJi4SzbWjsdes/2Zqea7
juk3PWP7M/YFk7TMRBpgJPk0ek3VH2cpVLP9mrk75WIbdIrZvo3umXKe6K7s
//JvmFb3QcI3jIOMnzOG9+rs1EEvtq8jLSMymMJ7ke3v+A8/x0W2z6NtdrA0
mdWf8XugSfjZCtb1GN9n8Ou0r6jTMf7P41S/wefnX0Dh0f16Z1U6oEz/RILV
kha4cFOva+bCp+Al8ssT45lIZ6LFlvRCqJV+FjNT7s99G2qN+IL7TEWXOjPk
ivqDiy4g70QM35cbJOcaKaMOYi059/sHVr/pPe/G4nl6+3hCve61QS/5PzoG
NZtOLmqHNvKF5tcM7BzV2gSXiIMGhi4kmsvWgSX5Q0vAy9h8ZSXbJ7otbfl0
TG8B2y/yGN15FeP+Vg7fiGlNZodbYFxnfKTIsJ9jUcdh/KSvRakXUBcTIU6q
DbMXxd9c5C/1n5GzmcvqL0i8dKs08qoG63qM3xQxzHdJbN9p4Y57X7mLW8F0
Y7LU/l8voCVj0j0x+Qb4VFq4RWx1DdTzXJ48orgMbqR/v4PxWDC7f2m2+J/7
ts7+cnJEcRTkmEomcLfcB+WbT22Ri6RTnaSxnR8gvwKPV05NDeBm9Svcv2DR
8PfxN9E8JtgCPuQ7fVu9QGTXmzbgIz9quZzf2ujnT9n6znH59zOtVKuhm3yp
CRuik1xPl4IGcdM4nrQBpWv5bJ/q9sqBiRj/OP0qprV19+3F/ORAHFWmpeiA
ulkj+Vhyw35BAJunoobnTQDkkq+lunzZFOyvT1z1PhNk8HqMz6Xb6r5seL9F
flfNcu4v6NOKaE0fdLNuhW6RREecL0YjlyfP1a4Eu3K+IdT5eDxWP0a9xT1s
ugnqBcz9rvfuP4M6SdekA7Il0uGwq11ZBfmpZfj7B4OlwfJy1PE8rkjOxX5W
tUYaeN64S6Ua+B4Zv2vZip8tF7WaQZN8sHUeytIYpxiuyqpL4P/+oBySyQ/L
mCjvr2BVCF+Ir2ybfopi/hskf0zAYKHQSrOM//LJmLZkxMblmGcZ3+xr32me
1M8RbP/MRNhBBd/3OeKuz6aFc/D3GPLTbvQvj0xh9X9A/BXY8OYt8g3jr/Fp
V+jgOIzPZjP1YN8Vkxo4OPqJ3/4vT+G7zU4LXI/R5uqrdZ4Ug+xt587tFflg
deRiO8Y5voqNx6fw/Lnv6pqeBOTOCam+D5BbXGyE1uJ6FO3fuBDb/NkKRnj8
8T8nzmI/yfWBR/C8pIOLN36MroLn5LOd+xR+YWtxLbiT/xbamS+D64jRi0LX
utajL8D4cCbNKY4vrPPYftznmLXqAdlZ0Ea+3KWru6bjvvgXhz/HtH8rqVog
LzQQl10v01XOFo9h+3b+MfprcZ0yfLZieH1GgSb5eGa7Z4phf0ZXKquSU8br
Mb5eYs5YCxyH8fe0+xw7cP2F551UWXKqEiakf87AeeLZJjpO/x1rX7V/YiXy
d/0Fp8nII9b9VqeQN5j71Rfo/oQ8czfadEp0VywcGHtGDMeNHV5nseDUM/Pn
Q9bxbstHZdivNvWZA56X4yTqivs3efL3LulFqq11LoUY8v3yQsbw6rC+L8Np
16KPhCAfXSb/Tzh4tTnGXUZfqhgvUI/zlvEDvz5wmIX7GE5fkGnbTq+OQ+5h
+C3Q/8zP4JI4tl/4NuhOAM4Lc+K49Eshd/F3AfmHwoq+77A/w3Pfi2088XqM
n2i4bIPHsJ9IvmJw8uaXqIu0/VIs5G7JhcXnFTzw/vu9vyRifBDeKWWO+4cs
qUl7kYN7Z4SdQQ5m7ve1erss8s/DS07VHm4JMFTfFoDj1ai/9sNWtsK3CI8L
ESddlpoR9lv/KRRGXssv80vA63coOHQjpzm12qUit6WkeYohn5nWJIsjN7Lz
V/SKXuSuBHPPdOSxK3TdZ8NxKhEyps1KweMSeQXDetakMLu4YT/R9bdOxEu6
kC7pQPak+zA6zwbSdRQL40/HmceBBPEQD3HOd+KbIOIaYeKZSIYLiF8kiFsY
PrEjLtlFPDKP9BkH4pHbpIvcd9DzxX1VH/HBWcr7Uym/P6Bx0ihfM3k5mvLv
atItllH+fUd6QWX1RyucD76UD99SnmN8DCfKa8xztFCeYvIRs7/no/zzlvb3
HZR/2Pt52r8r0z7710wHHZwH6pQfHlHcZ/bTPynOR9C4fBS3mfjM7IujKR7f
on2xJ8VjB9oHM/teDdqfSh+aJYvzvY3ipR/FQUY3Z+Ies/9k5hez77xJcU3z
f9QhrKP9JROvFtJ+coj2j/m0X+yn/d6e2ISxOD+XUVy5QvGimOJCOBMHaJ0z
65mP1u0n2o99onXrMKDxGud3WYRv+NCPTuB/93t/YXo+5h1y7iNTr/UnPTJB
JIh3Si7fY7jdoNWP+4yuz3I/kHtdFn9WOTy+DhJ9TQ0a9PMhdJ3Td+SL95cv
t7SeuAR9w3qnE4TvfztTeFonbFhWfCIktQUaSc+s8G+I97pXCVqkY9oL849D
HuIm/XKShNwn1IsY3XL3zeQE5HVGrxR4zeXuccEPikmfzBLRuKF+8xmoNarG
YT1SjM/q4xiPWj4fPYe8ob3t6i3kUEZX5Dt+wgx1u7298mHpgq/gPemHV4mb
z9vzXsF9kqtgiSDmxVGkF+oQF1+6Os8Q45sDh14oG+aZayYS9l96offsH/tx
fDvSC6tUHSYgd7qSPhi9XUqqbGkTDFz2FMd8FXp3/Hmc1ztI92vPm/RjuK6H
9L7dJ41EeyL82Trfprk/LHA9T7rwj9yBUW2QQnqeO/FpZKPyHSeLOraed761
PRn3V5b96umYX0aTbqch9cUT9TBOvY5PsVQe+dKe9DqJKRN0cb8VxOhzjuML
t1fUwT794rmLNpTCPe/njriPeOuVaoXrjdHZnFL5+jXi/uhrtycrLQ3JCQWn
GTdsBH80snU0f+K9pkXnowarqkCKdLSjkT/34Tpk9DMzQ+MpGIcZ3cwoZqcx
rjdOvUzN8K4CvjdGL7Nsv3UPfdFFpI/ZP+492HS0Cgrijo7qY81Habn9Mt8f
ZMJHY4Ov+H0zuCOK8PuuI12rnfufHgWzKOhVmOO5+3UNaJJ+NWXw+OXWvaWg
Q7rV7rNT+VH32EB61aGaK6b4PceTTgXeLTOQL2yumygh7xxscjXf3hADJqQ7
ve4O/pU9oRiW8Au8Rj1n5pKRmzDffVvBdwaf94uE5JaLBrEg/G3fU5wf0Q9M
d2wKLwEZ0oPOEWdY+HdEZk/Lh3OkB924bmiA8Wvf2uA85IjNe1zsuFv+1BPp
tcz0Ry5wydkujL/PkY6T+7fJioqN2eBD+g0rC7mi72RAuo2ATLCxb3AKrCW9
5if/wz6MM4xOM36j5Ur0s/aTPqPUw7UMf7uS/hLqmBKGz7eBdJcTC2/HYD5n
9JadsXkz8bqMzrJr1pr3eP25pK+cpXzO6CqJEb+Pa5NucuRZ5bmKwpfwi/K5
dsGJ/VmT6tl+T8LfPfXo33L6PIy/836Ev5Fm+DV2vveednxgY9pFtp/DWX9S
R3UnjI/zv+pPGD/n/9Wh/K96FCZOMnUpZVSPwsRLpi7FhqMuhfF5VlB9ypb2
/YHchm3QnrylTP50LRzOPntyvuYTtm9T0BN1uUT6Duxcn5a3550neBF3vBX4
Os58ZQz0Uv2IONWPzOOoG+nlqBfhrBNh6kMuUH2IAdWFxFBdSCnVgzD+ClMX
Ylrb4XboZzNYhi1eGV5fBSJSPGOf6uax/RKBnnUmVqqB0Jv1fB36Yd3ENXdk
XgeVb2SdT3Ub76lug6nXYOIlU7ex+X/UbXDWazB1GhFUp9Hzf+ozGL+DqdNY
0cb3vES+ns1Ffy2dobHKopzNR9U3rwddNsph+xmKnQmT0Idc+Wz/gk67ELZP
sX5rvRLqxp846ircqZ6C8SckOOoqtlFdBRNnmfoKzroKplXgqKuQ/T/1FIw/
EUR1FSPeLZCSPVrN9iVWT24Uk1hZxOYyB+5pa5acymL7D4da56RhHYTtwKtx
WG/CcFvfqYJa9PM56yCY+gfGT+Csg7hMdRBMnP5/9RCcPsMDqovgproIph5C
mOohBjjqIdSI/5i6CJ+eW5+wzovhQMO+m9/H/cyFn8SD1g3q0RlD6WwuZHyE
jSZFS24HxcLBcXLfcB73ES8Geiab4rzgp3oGf6pnqKc6BiYPMPUMh6iOIYrq
GNZy1C9w1i1w1iswdQofiTOZegU5vhZn9GumRoYHou/wOkrv5VThVLaO/6yD
6+rwfc7oe3N+cwJsSQrlwedqI736MenUfqRP7yRduoz0aGHSoace3vdyXVg7
TCed2fSf48+djjbBXtKVjTRPjUOO0yMdmfHL95Fu7Cv55eK8ZfdAjnRi2+a9
h7DdTLpws6RzDReL1xg/vIL03luk89aTvmtCui6j5zK8mUB6bnOoz7zw+hfQ
Tby5kPRaxrdOz1krgvtEOdJpvWaJmeO6ZPxqL9JnOX3rKxQ/zUifZXj0eFjR
a+Q4hkd/kD7LcOmKYZ3Oi+1jfyJ9VpbfuySYxWUuxKfPSHdtIr11AumsTPy+
QDorw6dqpLMyfDqXdNa1FfGNU8c/Y/vNCqSjMr6zAJ+wHndLDUwh/TS/t6IR
9Wlf0ks5feYrpJM6r749fkRNGJtbOfVRXekj8/A34zerkD5q9yY0F/Vnxmd+
S7qnPemdt0jn1CB9k+FYRt9kOPYM6ZtFWosNn5s2sDlWnUO/3Lvp7W0lz0pW
3v+tW37N+UcZ654mkE7J+MBlpEtGVRsvW8niTIZnj5IeyXCtT9eSxf/mWkaP
bCpOTOtxjYaFxLc/SGeUJ32Rn3TFGtITXUlHZPg2j3TEbeVhH4JLqtn+bBjp
hPtmX4jquV0MpqQLzveSDkUdyI50QMaP3Um63+v46Yv/rfM13f8hjy2j6wk/
fbEL4+dh4t5JpNc9J53OhvS5vaTLMXqcI+lwyXfVP+F+hvFB80lnY/iXK2ze
AuPReTCV9LWY8pQZqK99Iz2N8T9fkH5m9fNiNsY1Ri9juNg5+oUv/mZ0spwn
XXXD+z/iYxnSvxh/cyrpX4yvyehfjJ/ZRfrXWuJjRv9i+JjRv3SIX12IkwtI
91q/339jKiuOMbzsTPrXFHOhN5inGW5mdDBOn/Io6WF8G9/o9AT84eirxM9S
Ar99UoanGX3MNLlnK/YfJF/yPzWN3l8=
     "],
    VertexNormals->CompressedData["
1:eJx03HVUVU3UOH6UkLRAQMVEUUCxAEGBDRICUoKEikopgoKUSAooEiIgqQii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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.792339929182897*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1 = N1,L - \\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N5 - \
\\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N8 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N1 = N1,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 - \!\(\*FractionBox[\(1\), \
\(2\)]\)N8 = ", 
   Rational[-1, 4] (-1 + $CellContext`\[Eta]) (-1 + $CellContext`\[Xi]) (
    1 + $CellContext`\[Eta] + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339929214143*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJyNnXmczmX3xyciyWOvFDJSSCVCluhCyvKQJWRvsiZCKGR5GCWyZF/H7mFQ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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJyFmnlcTun7x0NIlmEsmZIiaoYJY8s6lzGRLWWbiIxptWcpS4o0USMRSpRU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     "],
    VertexNormals->CompressedData["
1:eJx8vXlczVv7/x8qUyqpCJmlwZySqctc5ooiIRKFEpEhFEqZQ1ESGjWpFE1U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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.79233992927664*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2,L = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N2,L = ", 
   Rational[-1, 4] (-1 + $CellContext`\[Eta]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399292922616`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nXmczfX3xxVSWbJny0iyZs2+zNteskR2odAieyqRJQ1N9mwZSxiRlCUZ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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJyNmnlUztv3x9MtcQ1XuS4ShShDoQyZniOX20BxpYRMESlxpTIrGaJyy1wq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     "],
    VertexNormals->CompressedData["
1:eJx0nHc8lf/7x5HSoiXKTqVdipZwJWlICKlIRVGShpYmkpEkKSMlo4xQobK5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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.7923399293547564`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2,L - \\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N5 = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", "\[Xi]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N2,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 = ", 
   Rational[-1, 4] (-1 + $CellContext`\[Eta]) $CellContext`\[Xi] (
    1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.7923399293703794`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1XXlcztn3J8swtpmxL0Nj35V1bF2MJcbO2COE7LIvQ2TfGSQUla2USntJ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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJyFmnc8l9/7x1U0RBLRMCtalCKVcBlNSj4tSgppqVAUKRkpEkloCCGEyt7Z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     "],
    VertexNormals->CompressedData["
1:eJx83Hc8lt//OHClklkihCIqFe2UES8jo6FFFLKlKJQVZUUhlURWIiMze2Xd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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.7923399294484973`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2 = N2,L - \\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N5 - \
\\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N6 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]", "-", "\[Xi]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N2 = N2,L - \!\(\*FractionBox[\(1\), \(2\)]\)N5 - \!\(\*FractionBox[\(1\), \
\(2\)]\)N6 = ", 
   Rational[1, 4] (-1 + $CellContext`\[Eta]) (
    1 + $CellContext`\[Eta] - $CellContext`\[Xi]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.79233992946412*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nXm8jfX2x0+GBvWjew2RiuomqRQSib6mhIxdSl1JEpUMCWkSQkQZMmfO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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJyNmntcjvf/x0MOc5pzlFaxtDHnnG2fvkSbLTnOaZmlRGahiKZJiyhxU0Sk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     "],
    VertexNormals->CompressedData["
1:eJx0vHk8lV/3/4+UoihDUkmTIaVUkgqrQWiSjEXmIsqQIWODUKmIUpKEzJky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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.792339929526616*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3,L = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N3,L = ", 
   Rational[1, 4] (1 + $CellContext`\[Eta]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339929542239*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nXmcz9X3xyehzVrIEkMJKWsk21yplDVryFKWSpZIKlJoTFJ22bfIkkJ2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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJyFmnlYzun3xxvLyC7GF4lClqKQpWzPmRKlKRopWVtMluykMSYqZClL9q1I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     "],
    VertexNormals->CompressedData["
1:eJyUvXk4VW0b/62ZCk0oESqaJJUSpavSIBmalKiERANCGgkRilQqNCcZkjKU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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.792339929604738*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3,L - \\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N6 = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", "\[Eta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N3,L - \!\(\*FractionBox[\(1\), \(2\)]\)N6 = ", 
   Rational[1, 4] $CellContext`\[Eta] (1 + $CellContext`\[Eta]) (
    1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339929604738*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJyNnXlczun3/8kyhrEMMcjYi8m+DxkXjSV7lhlZsobs6wzZSkbI2iChEKFU
pE1IN1kqDGkhkXKTyj7GGIzld7/rvM59dz7feTx+88/98JzjuO9zrvf7fb2v
13XO1WDinKGTzUqUKHG9bIkSpQyfDbIGRnz+/EKHz+cpl+d1f/8mdsrCsJ3R
s54wH+uzIeNcQYe4IxWquc2684h56rZT9c8V9Ip7vv+XKY376pmfnr3jiP0c
+7jJhX7uMK+09caFswU/kX2K0f+JCtmtnUYTj2ee8Wz/Mvs54+NK0H/gJUqc
Xbe2+STYK/CmVbO8zxZMhn/mwxq/P/D2kDO+D/MlHb853tppBr4/8/127eOc
G8zG72U+JTRwsv2cuXEUH+YuHTvNfPrHvDj6M/ONuovz1zZfEMd/n+KaXHDV
zDGxLfwwvxPyY7pfwTwd4gx+6UIJ5VewUoc4g9ePGLd1xj1PHeIMfsY++y/f
Ai8d4gxekFCpbmknbx3iDG6uutnNuLdLhziDd4+eNT/FYS/sFXi096BrvgX+
8M98wNApk5KtAvB9mN+vuOJtKadD+P7MFyVt39jJPxC/l3ml1aENZ9w7gu/H
/FD3iyf2WIRifDDv8uHugBSHYzxujPGbMuzFQMVxBrfz+zkuLHM5/xmfYQ3z
zh/L3MhxBndcOmRbKUPcEGdwp8nHeh/L9OM4g0ce9lgWGrif4wwe5Rv1kxYH
xBk8xuthy5H1jnCcwU95VCt3LDOU4wye/YP/XLMrYRxn8HEx3zuGBoZznMFz
2ib3dfCI5DiDTwid2rGUUzTHGVzf5HPDoz1iOM4cz/3elUfWO2W8X1Ccfh0W
03pMoi3HGdx50eOvtHGLvw/+YPvhX43jU8+fNV7enjLdMA4RZ/CGlh7NTMYb
8++H7m1kHFfxzAe5xlhMN4wfxJm/T8iNajcM4wRxBj838+8yvgXHOc7sp5SZ
+3WrSI4zeMbOSp/MDHFDnMGdWlss6egfw3Hm33epyZtp905xnMGXObaf72dx
huMMXvp19+fJDjqOM4+7s7/UMI0zeEzh9W6MM3jZub6OpnEGj+zUt4dpnPEZ
9nlJVdM4g7tPGlLaNM7gDgna7zLGGbx5s095ySZxBnfr8/jpbpM4g890SZ9s
Gmfwn4PP3jONM7htVvAI0ziDN628I9k0zuDmPdz7msYZvMSCWfGmccbvDix1
K+q5yX0DvH1Utaam9w3wtSqghel9A7xofHqL8ZyiC/ltZthRk/sGPrfd8a1r
et8Av7qwVK6ZyX0DvFyl6cEOJvcNcLvDyfOOmtw3wLvvs6hjet8Av/t00OcQ
k/sG+OLO7voRJvcN8JoeURfNTO4b4JEp+YGhJvcNcPt6dTY4/M99I16X36Ld
h9Emz0HwKtZpmb4mz0Hw5v28evqaPAfB7Quvd08R53hd98w573abPAfBkwvj
6S3iHK9zLhw/u0Sc43Vvg6xjk02eg+A9G2an7jZ5DoJveRHY97rJcxA8I3a+
zszkOQje1LNrh44mz0H+PiPKBk8zeQ6CxzROru9n8hwEL/Fqp3eyyXOwhPgP
cZYccZYccZacr5//0z7lP3j8//D/+g9x/g///8MR5//4/v/DEWfJEWfJEef/
4Dwu3q6O72ZZoXM3MZ7Vy0RnZyv9IiXGsyqxt/I+S/0aJcazOlv4PPJSYjyr
EuUf2FjqdygxnlX3wuvdT4nxrGh88vcGf/gyfXZOboAS41mt1V390lJ/WInx
rOpvOh9gGIdKjGeVOOaUMtxnlBjPKnK7wyyXGWFKjGdV+mPqKcP9X4nxrByc
BpeLmxqhxHhWAVcu/5STG6nE/VmVbls+Z13zASLOKcqpZrtWhvmwiLOBJ10b
aHjeiTinqAGFz/cAEecUle9fJ0v7veL+rOj+KeKcojYVXu+RIs4pKrNbx0W+
7idEnFNU48J4nhJxTlELs+xTOnaJE3FOUeNrvPhc8spZEecUVTYuyjt/cbyI
c4o6OnlZi+tWF0ScU9TPFX+8EJV2UcQ5RX2I/HK0r3uCEvMNtX7Kx5z5S0Z0
E/MNlV04n/dWYr6hbv96pKthnsBxBh//l2c3LW5ivqF+Knq+c5zB+016s6LU
x9McZ/A9Fb0rmxniIK/7nQVh49x3nOc4g2+7eOWYmdMl/p3gm/wffXZvnaTE
fEOtXV7SvtTHKxxncPeRdfatSrqmxHxD6XZZvC15JVmJ+YaKLfddfds2/P7J
PObXjnbuO1LFeNarShcHeAV1miDGs14F3Jk0dsmMfWI865XF5kNp2vUl5s9q
UtH8U4xnvbqZn7DZZcZZMZ71amnh8/2CGM969W3h8yhRjGe9is98s8Y89qoY
z3q63pPFeNarMoXjM0WMZ71yeFT17AiPNDGe9Sqo0tyCS1tvivGsV/92/KNq
R/8MMZ71atA4664Hj2aK8axXe9esmWwee1eJ90GVeW5m5vwlU7uJ90HVvqfN
K23civdB5VT0fsRxBv/5bkZnbRyK90H17/3lGSbjjfmevIaLjOOK3weV/5sH
5c0M40c+lxa4dByljRPEGbzXh7VBZk43Oc7gNV3vvHVvfZvjDP64ZEu7Uh+N
cQc/9ZvbjlVJ9/jP+ExYNe2vkldylHgfVK0vVrWwbcPrI8x9ysbauu94oMT6
hgoKutd/++rZHGdw/6L3d+P7JPHe3j7nDfNzjjN43d6Hq0cb7ldifUPVLJzP
/8FxBi+352g37bpDnMFXW/hmRKWlc5zBzXaum//d4tscZ3C3Gou+8rPI4jiD
f+7bdtjacTkcZ/Ci6904jsGXJtR79q/ZQ44XeBePGqei0nL5z/h827PimjmH
8pRY31DRpUoP/25xAccZ/79rtxva+hLHGfyXfLcRln3DOc7gOQF14kzfe8HX
pC9Ojp51heMMXmPV9Hmm7w/gzrt9lsy6c5PjDH4q4tIq03kYeMWrrzd8/pzN
cQZvPf/r/qbPM/BRKwKv2/3+kOMM7u6phpveF8CDvW9meDUu4DiDp++f5Wga
X/DPR0vrM6Of8Z/x2eT07ina54WmrlZ3op/p8Gn7Kf1u/NRhPK8Gf3LJ/HyV
kY3j6M/8985k2o30HLeP4wL+zOXm6MT3+3TCvzpbZK+Ef3Xb+s67Rs3mdRP+
1az9ee86+D/hP+PfqdbBvvGsO8/534O/RXtb250vsIwT9rrSS1fM6bJ8fpyw
V3vm9PW06rtfie+vLPMtl7c8/FS9cn800/Dv6PBp3mThsttW7fFn/v9p9x7N
GzvESyfsVWoRV8JeuXn4HEk5b/x++Hvtzx69PLNB9TjY4f/3/bbhvPtp88H5
+5dYkfmiad/f+fvzvzvspovjIOP3g59ToYubXCqoHifsdQG2J+Lf+XvpxPdR
955G3ohsOr+b+D7q27e/9Iqe9UIN3rH5n2t/PeX11acWYzc31U/VLR9yw2ZP
XgH7W7ig1aGQTj/EBYt19WRaV4c9/JztnzGxiX6RLrj4/VN3gdaHb18cfqHr
9Qfs59Ecx+fBnQbGgfNzb9L2q1b6Nbov3LzLfXU+h+1dLUuMvWI7NG6aWLf/
itbtYQ8/m82sR4VlbtRNK35/1p2m9ecL+e0a/vRTOvvxLnGgWfSWkXHgsG+5
L+jU/dxtum6nZv+U53KN7RvOXvh7cCfHuNfF7zO6W6QLwB5+9r1YsNJKv0P3
uvj9X1eV1rePtHyVtXpCIPvxDajQ+ortxDhw2K/eVK5yWKafblkR5/E2cfTC
B71qOMXlF7+P6ZqQ7gB7+Pkwu2C6Yf6myy/+fNFF0fp526Lvz35eJPbqZ3Nm
ahw47OfERbTRTT2giyuKG9tHuR79GLVlWtyk4vdJnQvpGrCHn6aPam6/nxug
m1T8+aXLofX50kX5ZT/qmatTcKdZceCw39XhwWgr/WHdzaJxxfZlAvK/saow
Jy5Q6CaTSTeBPfwMc7TT2Y0P0gUWfz7qKtL6/5Ki8c9+Eso56iqOnBcHDvuE
kKoeG8eE6AYUXXdsb+30da0rtvPjwGG/Mm1RgbaujusUz0nbybctG+Qt4OsU
/PDjac3q563i6w48hPQCXF/gI1u0PVovbytfX+BjkuYuycvx4euF1+FJR8B1
AR5eYtE6m+n+fF2ARwzynlMv7wCPc9YdSF/AeAaPfpxmk5cTyOOZdYfvXze4
4hjM4xP8JOkOGIfgY6fXWpTULIzHIesOX3833Wb6cR5XUo/A+GE+zs6+Xl4E
jx/w8WUdfvSyjOLxwJx0CuSd4zZ80Xe/7D/BeQef+K9HnbycGM4v5jtev3b9
Tbt/Ir/gHhHRI7T7IfILfp90CuQX3CxlwTlLw30G+eX5VKXuX2l5RH7B65N+
gfyCt/rxaXKO4XpEfsG7TRj6q6Xh+kJ+wQeQroH8go/1q3tOW+9FfsFjHG0j
DO+JnF/ws6R3IL/gSUsDHeKmRnB+wW94jg7OyY3k/IJDB0F+wXMCz9lb6k9w
fsHzTiw80Gf8Sc4v+DPSR5Bf8DfpmXYbxsRyfsE/Pty4+2jmGc4v5q25PYqe
j8gv+Aq3oR1N8wtemvQR5Bf8auG6nDG/4Nuuu+uPmuQX/CjpJsgv+JYdkRGm
+QWf3+r5cNP8st5BegryC9553IQdpvkF37R0oK9pfsFdSWdBfvnfrbbmB9P8
gjtlN9pkml+pvyC/4HaLHFuZ5pe/54/vXU3zC96EdBnkF7zWnXYNTPML/lXh
euYZcf2m6HokhJyrb3J/Bt865IeEeib3Z/DfSJcpfv2m6E56l+lnen8GD6vY
+eMjk/szeBDpNcWv3xRd6sfrbUzvz+D2J6dVML0/g18hHaf49Zuis2vtF/fI
5P4MnvCko89lk/szeB/Sd4pfvym6CW2iLE3vz+B1K7tXNb0/g0P3KX79puh2
XrZ4Wtfk/gw+IjA/Y4vJ/Rn8G9KDil+/Kbq0Se7hC03uz+BePQbvffQ/9+d4
nW3FhT2amMyTwZcNfG5uZTLvBbcmPah4fuN13rOCV1iazG/By3pdjDlqMl8F
70Y6UfH8xuteP1nmnWMyLwUP+biunaXJPJPXG0g/Kp7feF2dBgGzjprMJ8Gn
7XRY7WIyPwT/kXSl4vk1zH+DJzeMM5kHgn9s93Rujsm8Dhx6U/H8xutier2r
aGkyfwP//ZrrmD4m8zHwqaRDFc9vvK5PzoZ3603mXeCNp1WzO2oyv5K6CfIr
OfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIrOfIr
OfIrOfIrOfIrubh+VdudZj3aZ8xR4vpVfXvZh7XNcFXi+lUf9xTpX+L6VUMs
/slrk7FZietXpfR/8Y3hvq3E9as+flmki4nrVzVNvDmuWdZuJa5f9bPH5VVt
MvYqcf0quu6UuH6VQ8nbuXXzDihx/ao5OSn/+D88qMT1q9aQjiauX7VjzyWL
wOwgJa5fFbr8bItmWcFKXL8qgfQ1cf2qLJvIIW0yjilx/SqXirfaZD4OU+L6
VaVIdxPXr9ryNPlHx/xwJa5fZXH3j6uG+78Sz1/l88JpvF/BSpHfFLVjXwlX
Ta8Uz181gXQ38fxVNVwGVTLMl0R+U9TyjVF/G+5XIr8pKpf0OPH8Vf2iV11I
djgm8puiRk7+O137veL5qzaSTieev+qsy5gzmg4lnr/qVakqbTQ9RTx/VSPS
78TzVznUXFRTW8cWz1+1Yb/1hmQHncivUdcTz1/lcifx5O6CcyK/KWrrvv0L
OpQ7L/KbokJJ7xPPX5Vo/XOec6+LIr8pSv+ilb+mU4j5s7p3Z+bLsMyNSsyf
1bXQi4sN7zVKzJ/VTdL7xPxZXajxKlYbt2L+rEYV7m8JV2L+rIaSDijmz6r/
0od7HOqdUmL+rH7sX26cYX6oxPxZ+ZE+KObPatffh1+EBMYrMX9W3lknr2v6
l5g/q62kG4r5s9ocmrU5tEeiEvNntX77izkO9S4rMX9Wa0hPFPNntWpytdZH
M/9QYv6s3AZaVhkZc12J+bOKI51RzJ9V7KbGzrdO3lBi/qxOubfICAlMEdev
Xm3t0DznwMPt4vrVqxW+x6/uN9zHxPuvqkU6o3j/VX8Nfm27/2GUuH716o8q
tscvO54W169epZH+KN5/lW3S80sVm54X169ehQVV/+T/8KK4fvWqDumS4v1X
eU6fNPOy4xVx/erV236eB8bWviauX72KIL1SvP+qgjJP155PuiGuX72q/6tr
QMWmqeL6NeqY4v1Xbfr50B3/h+ni+tWrC5c6//PE9pa4fvXqPemb4v1XtTk8
vqXb59vi+tUr529e973seEeJ9SsVea1afpjhOhXrV6qS/8y5xwzXo1i/UhNJ
3xTrV8qm/M5I7foS61fKs93kWqGG60isX6m3pHuK9Ss1eYv3Du26EOtXKrXb
sZ+18S/Wr9Q+0kPF+pW6NXDuY208i/UrVfHghyQt/mL9SvUknVSsX6llw6qv
C+2RocT6lYo44u/sUC9TifUrVUD6qVi/UvVGnmpyNDNLifUr9VNY7y9GxmQr
sX6lLpGuKtav1MRjrSbdOnlfifUr9SHz75SQQL3UEdQR3zcJuqkHlNAF1IBX
Sana/hmhCyhb0lXF+r/61i9iZNzU80qs56uaL3bd0O5vYj1fVSe9Vazbq7VJ
keMvvU9WYh1eecwPrBM3NVWJdXj1G+mwYr1duV/YvE3Li1g/V26zVtlr+r5Y
P1eupM+KdXK1Qjc9cdvabCXWvVW39q1sL73PUWLdm3Vbsb6tbLIafjoz9YES
69Xq1PE6dzvveajEerXqTHquWJdWMaOq+LSpkKfE+rPq2Kr8r6E98jm/rJ92
uftkjeH3C51IbYyodtJjQowSOpG6R3qu0H3UP3OO1fOYkKiEvqMq29iu1OIl
9B1lTjqv0GvUPoqj0GVU80EfU1ZPyFBCl1ExpP8KnUX1qrWlfZ7LPSX0FDVN
F/KqgiHuQk9RrUgXFvqIetP41wNaPoQOomJvZf47/KdcJXQQ1ouFrqHsfggI
WT0hXwn9QlV6Wa6Mlj+hX6g00pGFHqF2/ZQSpeUVecRnyPyF7p+dJ/I6xveF
v+O5rsoqqxRNB0Qep5IeES/0uyHkp0rTpJUaRx67kJ+9bU+M+E6/iNcxnKEr
Cd0NfkKr3vj6eOZGXseAn1yvFo32Gvwjj/DzldDL7MnP4RVP7fW523gdozP5
Webpuus7/Rpex4CfMKFzwc/bBS9rzjT4Rx7hx3zVja8jDd8TeUR87gp9Cn4O
tl/yUtPXkEf4STvj1XOvIQ7II76PmdCVhpKfXq2WpWn6GvK3tfD35eu2lfr6
gel6Iz6PZc873S7DlfPIn0IP2k5+RiVW8NHygjy6kp/r4cfsxub/znkMQb2J
0IPgJ2XwsH/m3t7DeVxBfqKfue/X7JFH+Dku9CD4CZgxMNgw3+M8ws9g82Yr
3KYEcB7hJ1roQfAzsdWfmRvGhHAe4ef8cfNmQdlBnEfEx1HoQdvIzyaXfqu1
9UnkEX46DP50S6vXQB7xfcYIPcib/DiPruPX+lAkr0e5kZ+hbxbYfnQO5/ze
ovz06V1cLzhX+DtydaV+7NT5wMPVnNcXpDvkCD0InymWG7s4PfDm/J4nPwHV
c121Ogvk9yX5qSf0IPgp923bQdq6MfIbT34e9txxvMfkg5xf+Okv9CD4sT78
rauWF+QXft5+smk0aHQo5xd+dEIPgp/DPqUzPhjihvzCj8eYuf20PCK/iM8t
oQdlkJ9oxyVzIw5Ec37hZ9NJ21UaR37xfZ4IPSiT/Fxo+LLcdANHfi+Qn601
qsee3HOK81t0v72n+2BbPL9lKD92u0r3MdWDpv6HHtSF/MwIcQ401YPwaf33
xn9N9SB8Sj3IhvxUCKgYa6oHlSU/3teuTjPVg5z/Qw/C98n589EBUz0IfgYO
KThiqgfBj9SD4CerXk4vUz0Ifuxtnu4z1YMQH6kHdSY/SZeudjbVg+BnsOUL
b1M9CPGRelBX8nN81skWpnpQOfIzpPKrDaZ60FmK65l3VYrdn4vu2xm6w3/X
/8L0+n1JusNqoQchP1Zj9tzX1vmR1x3kZ/SQI6ebZe3mvL4iP8FCD8Lnq65d
L35w3s/59SY/L6vp32nr8Mjvn+TnqtCDzpOfa/2Dan057gjnF346fn5efe7t
o5xf+LETehD8/NyiwglP6+Oc3+3kp+vfH31mH47g/CI+Ug+KJz/xkT3ua7oP
8gs/2dNLN9HyjvwiPrWEHnSJ/LTturjCjvonOb87yY9rTvmoO3VixfM3Ufc5
rXSCqR70PcW1+5Gaf7U1ef6+org2E3rQTvJTafqYq82y1nN+u5OfH6y7nNXy
jvy+gQ4l9KBd5Gf+9aWpmj6I/OLzjfmtCZmP93F+8TlT6EE+5Od5pFOOpu8g
vz+QnyRzr0kXJh7m/MJPH6EHwY+Ve4URmj3y25X87DPvP1kbD8gv4pMp9CBv
8jNqcPgfT++EcH7hp7One7sB34VzfhGf2UIP8iM//TY136+NN+S3J/lp6jmu
fY/JUZzfbRSPjj/0tLesUIv3uRWNqxhdvL62i5XJPLlIbdgXW/RpH4v8hpCf
4THnwiwN9shvAPnxKbwPr9QV14PCyM/iWOQ3nPzUbbR9gKXheYG87iM/S3sf
89B0w+J6UCD5WRHL6xX0aRal5Xcl53cP+Qm7NG+5Nt6K60Hw81ss8htIfuZm
rKit6ZjIry/5qf94/QltXBXXgxAf91jkdz/5ufuvz3Dt+yO/fuTnatnUxZr+
WFwPQny8Y5HfWPJzavPIBO26QH6Dyc+mmjnV40zmz78XcfW4wv0O7Uz0oE0U
j4AVOuu2Bo78PqZ4vBd6kAf52WPTx1HjyO9c8pN6ouXBNhmu/Fx5RH7+FnrQ
KvJTt/b6N3XztvL77GLy06Mozny9IT/dhB60hvws9p7fTdOVkN+l9Llj+JSJ
mm6Fv49PN6EHrSU/k75scV7zj/y6kZ9f863Ste+J/CI+54QetJ78bEuon6fp
UDx/Jj+7D9V+19gQB+QX8fnwobgetIL8RK42r6DpU8jvRPJzwKnSt9rvRX47
0e/YtqCwvpvzW5T3RJW7YETJoOx1nN+npDuME3pQG/Lj0beMneG9hvPrSX7K
F+578eP8PiY/OUIPak1+9odcLm14bnJ+N5CfGkX3Sc7vE/LjKfQg5Md2VNIr
w3OQ87uR/BwqzO8xziv81BV6ED7bj20xKb1BDOd3E/nZvTWno/bvIr+Iz1ih
B7UnP5YTvVI/7jrD+YWf3A8bY7W8Ib+IT5DQg1qQn3IR7xtU8zzH+fUgP1ZT
bGy7+saq4tdvhrLu032DqR5E8y5VxixDr11fyC9+h9SDtpCf8lPKVjC8p3B+
Y8lPVNLK7ob3FM7vBPJjL/SgzeSnqeOKd9UaneD8niE/3yddSdDskd+J5Ge3
0IPwfQ6ej/1V0yOQX/jxCf15jm5nHOcXfrYIPQh+oh1OvdT0NeQXnx8S51bQ
1lcRF3yuFnqQF/lJenZiurZOjvzCj7VNx3FaXR7yi/jECj1oE/m56R71sM+7
a5zfU+RnWOi/4Uv8rnB+6T1I5dyLPWiqBxVd1/dUGafnHT467+f8PiPdoabQ
g0qRn4nrWnpo4xn5bUd+En7fsG5o42jO71PykyL0IPhZ8+zXr22mn+P8tic/
Se+qdNXGLfILP7WFHgQ/jt43x1U6l8j5hZ9WR0a3+1gykfMLP+FCD0J+dtWz
uPWyQjLnowP52T7qkLVmh7wiPj8LPQifZV/3WzHqRCrnF36WrX67RauPQ37x
ff4RepAZ+ZmduMTywsRbnN825Cc4y29DVmQ655fWMVTgjP4HTfUgWvdQpctm
VQwy3OeR3yCML6EH6cjPrz+V2tYs6zTnN538eE44fV/TtZFfnicKPQh+SuaP
dE1vkMj5RTwq1e+551FOIucXfvYKPQh+AqqO3OVpfYPzyzpMn/TJ4eVvcH7h
x1boQfDTr02ZX6x73uT8ws9g17XL/gxI5/wiPvlCDzpLfp4NPj5Y0+Pw9/H5
Ktpma2uVyd8DnxeFHhRHfnqfaFk9yiaH85tGfryePw+ac/se55fyqd4+nLzf
VA+idUu1/K/dXddbHxd6/f/qQUvJj/8Vtx1avJBfL/LjFThlW07uBc6vE/mp
KvQg+ClV17m3pl8jv7+Tn8hgdfGH3cmcX/hxF3oQ/LSPOfxeqwNFfuGnXqkB
3defv8n5hZ/lQg+CH+cJFkMn9M/i/MKP5yiH0xlP7gq9/ok6LfSgZeRn4OqE
tOUl9ZxX+Hnv0Naimud9ziu+TyehB+Hz4ciVJfo75nJ+t5Cf0N9iMjRdCfml
dWx1o3mbK/UsDnN+6f+rhas+n9b0d+S3/n/oQR3Jz4TD25qZN0rg/A4kP5da
TzjmFXeZ81sPdWRCD4KfSwn27R7USOP8ws+TwRNKTOuVzvnF9zkh9CD4uWtz
y76r713O7yDys+CLqt+ta5bF+YWflkIP6kR+3t9qeeLyFj3nF35WjLsfmLZW
z/mFHzehB8FP6aqvei1KfcT5hR/b053PPFxqvG4RnxShB3UgP5UGRKU1qvFE
5lGn8z/TMDy7L783dSV+Y2X2q5Np25nTpy7xQ51rNnsCdEJXUjFFXAl71X1V
3xV7Bj5Wwr968+9u32+GGe2gW40v16mS9v+F/qjzWpJa/WinFtyPBf/fdXB8
mKZbwQ487Rfvln1rWHNfOHCnqtPytXVX7NcH91jxfaymZ2GfN3jmAq0uYw3v
hwZvNq37gOPcVyeeebdWDT39DO+hch9i/neNZ2v6FPaxgXs1thraRL+D93tx
fuo17TjT2AeJ+YNa1rWPc38eow7fq3yNz5reBJ0efPcX38zzK/BnPRv8z9I1
H2i6EuKJ6zjo8OuGAQ9/YY7ruBf1JUOcYR8Sf+TbB687ch8547y7qL8Z4g/7
uE0DZ2jrn+CwDxX9zWCf5rRl4pIZW5jDfrToewb7vmZLKhvmjcxhP0H0Q4P9
mb2TYq847mYO+3DRJw32PnsOtdfiDA77CNE/DfZDZ1msr9T0AHPYR4u+arD/
quuW+5r+BQ77E6LfGuwvlS/zvdanDhz290QfNti73nbZpNVVgUv9C+MK9p0D
nz8cV/soc/Yv+rbBfsnp498umRHGHPbjRD83nvc1fGp3Iek4c9jniD5vsO/g
abWwUtMI5rB3ov5vGLd4zljpjiy/89iNxy34l/0nHO1ypgePT/DIgrMvMh8b
xxv4rQUh9e3G7+RxBf7h05VAbX0V4we8woUePbwsOY/Ma607cVvbx47xAN58
UIv5n3aFct7B964bsjrzcRjnF7zpzA03OpSLMPY3IX50UMK3Wp0a8sXP2zZm
05/anuC8gJ+p9kO0poMg/uB93iwyO7D8NMcZ/FpG+KBPu85wnPHcXjXdq7R2
/wTHcxv93xB/2Gct+qeJ1i8OnPdtUR855AX2PdcNmq3pX+Cwl33kYN/fcfgo
Td8Eh73sLwf7wzVbNNJ0MXDYy75zsD9k1rqWse9cCtvLfnTs/2nbypoeyvUV
ZC/71ME+6GaHMpq+DA572b8O9j+P9/1o7F9n3Acn+9rB3iHdb7HW1w4c9rLf
HexH9Nv7l6abgMNe9sGD/UjdvtlaHzxw2Mv+eOy//f4CTXcDh73sm8f+gw44
aX3zwGEv++nx7617MNuknx7bo88e16vTvLLfyH+mavsouO8B8fk9LjyvGd6d
xyf4hMvpY9pmbObxBl7p9S13TZ/FuAJ/bNbrVpuMvTx+wHPL3a6u6ewYJ+BD
t1TurumwGA/g577pPb1ZVjDnHbzt3mXb2mQc4/yC228dma2NB94PTbzsrYWv
tboq3g8KHbP2li8N83nOC/jCscF1NX0N8Qdvtv9Su8Dsk8b+EsT1ufftDO/p
HGfM0295fIoJynZhjnm6OfXZQ/xhPzP270XODWz4vsHrLtSvD3mBfc0f/8oO
zF7H9w3Ytxb9+mA/wT9iXtzUrcxh/7Po4wf7Tv6zFgRmG58LsO8p+vvBfm3y
1i5JzYzPC9ini75/sJ+fPNdG0y+47gs6l+gHCHvH5IFdIw4Y5yGw/yz6BMK+
f7L1D4HZQcxhbyf6B8K+Q/IX3bT+fuCw3yb6CsK+svP8elrdHzjss0S/QdiX
zs/Zez7pOHPYtxR9CGH/furg+to+AXCOj+hPCPuXeWf2xZSJYg77ONG3EPYP
pzZvoO0DAYf9F9TPkPtW0HtkRqE+OMLY75f4INITuY8T8aGkD2K8gfsWPnfm
GfurEq9JOiDGD/jaQh1wOY8TqfdhPICfKtT7fuO8g88nXQ/5BW9dqOvx+Gee
T/od8gV+s1C/22Ls60s8hHQ63jdMvEin22rs60t8uv8UJ02XRJzxXn61UL8b
x30TWNeifoaIP+y3H12ZVjO8fjdw3mdEfRGRF9hvIB0QHPZv9xTviwj7bYU6
4CLmsD8l+iXCXk/6IDj7/7J4H0XY1yzUB1cxh31H0V8R9j1JNwSXuiHGA+xn
FOqG65nDPkv0Y4Q99ERwqSdi/MB+VKGe6MUc9t+I/o2wn086Izjs40RfR9h7
FOqM25nD/qjo9wj7naQ/gsP+04fifSBhH16oP+5kDvuhoj8k7M+SLgkOez/q
G4lxi3Wj2Db3Whvei3ncgg/V36inf92bxyd4XP1OLvuNv9e4j3Xb5xCXGft4
XIH38Jn0rVZHg/ED3to3YeNlx2AeJ+BVk6u7anHDeAD/MqXPiYpNIzjvXCea
5vLC/2EU5xf8bXpwE5O+f8z/vJU1TqvHQb7A829X9hlbO47zAv7qWX1nTZdB
/MFfPO/82/mkcxxn8Mcvhu7T6ncQZ6zDmU8sXE9gjnW4LOobifjDPqNt6Pag
TkP4vgH7ddR/EnmB/dTqqRkuJn0RYX9L9J+E/YV3jm6G5xpz2I8VfSlhX3XO
661aXsBhP0z0q4R99/sn80Z4RDKHvZ3oYwn7OcNcbbR8gcPeV/S3hP2eiz03
m8fGMof9DtH3EvaPLFbPM/Z7jOd10N9FP0zYf0qbulvrIwoO+w2iTybsq2/q
d1GrmwOHvYfonwn75n1avLi09RJz2LuKvpqw71WiSq1CXY847ONEv03Yjz35
yvbg0cvMYX9K9OGE/cL56TO1PpbgsI+m/pwYt1gnvraitNXg0X7GvmnE1YrJ
JxwTx/L4BK/uda7VoNF8/2Q+fl73KUtKR/O4Av++9r7IgaPP8PgBX3vfdWWV
kca+AOB/Rh1ruqT0JR4P4I6e2dcfHEvivINfHlt50cDR3C/RqG/urLd59Kpk
ziN48qoTE6uMNPbxBC8ze3DHiy3TOC/gNg55Xy4pfZPjDz7P1jWrZeYtjjP4
oebfHH9w7DbHGevuTYOCN2u6MzjW3dtQf07EH/b/ng8JejpwEt83YH+L+nwi
L7C/+2PXvz84G/sisq4u+nzCvlHE/oZL/fj+yfbDRf9P2Hf0Kh34wdnYhwX2
b0VfUNhnJp6IsymVwBz2u0W/UNgvKzEjXdPxwaVOivEA+yp1Kr+5a2HksJ8n
+ovC/sEJ55UfnI19n6V+ivED+8hh8V/ViU5jDvvqoh8p7D1eWPjYlLrFHPZ5
ok8p7Ees/6XRaPvbzGEfLfqXwv67JtePLvEz1u9JvRXjE/Yf4pt22fU4izns
W4p+p1wH1uqc/q6FsY4I9t7UBxXjFrrQtR476s8wzLswPsGjjsckr2s+k8cn
+IC/2qrp3BdazzyjYcVF2n4ejCvw8lfdrk27d5nHD+/H7PK+qjYeME7AO1aO
7HbdKo3HA/j1B7Om+7rf4ryDO8c08Z52L5Pzy/sRNt4/17HLPc4j+B9hf7zR
4ox8gdfafWRD/mJj/1muk1u9puF1q4ccf/DwOU4xmn6KOIN/GtljkK97nvG8
GdK1IufejnT3OcbXNfj0JteCV/roOJ7gP1zZ8Wl8eALHk+sJ3O2arPS5zvEE
t/T7cNhex9cL8/y3w2PHh9/ieIKHDA9NnnvQ2McBfG5YmVw3n2yOJ7hF2WPL
Ei/e53iC/9vujoe9zlg/DJ414QuvjJhcjie4bnO73ePDOT7M/c+MO5gfbKxb
Y/+7a9d23/FEoR4GulUdqjvDPnveV0J1ZLvovRH8KNWFdaR5IXjJhUV1Xthv
xPXKVLeFfQzgDlSHBf2b9wtvuf55gONBrpeDHmFLehnqT8BHkW6FugXw8aRP
Yb+71KH+pPz+33rTvljwKNKVnlB+wWNIP8J+PvAs0omwT0jqO9hfAj6WdBzs
S5B6DfRg6DWjqL4JOjfrg6TXYD8E9IWLVEcDPR58QJlmP138N5brAHl9nvQF
1Ocwp3V+7Pvn9XBany+KW1gsuDWtq2OfIvgMWg/H/ifwHrSOjX0V4NVo/Rn7
D7D+jDqRemL9+fP8ovVnxAHrpW2oHgFxAM933Vq/dt3THAesR5Wn9VLEAXwI
rVui3gYcdQSo0wBPoXVIeirHgn+g9UPsKwXfSut+iA94c1qvw3OI6w5oXQ5x
Az9D62+IG9bfLGl/fn2x/laW1t+4P4BYT0OdCXgNWjdDnMFDaT0K+y3AN9J6
FOIs15cQZ7nOgzjL9RzEWa7bIM5yvQVxluskiLNc30Cc5ToG4izXK7CPBOsV
52i9ov5/rFcgzrxPnPZFI87gAbTPGXEG/4r29yLO4OUiq3VzzI/nelq872TS
+zjun/K9GPdPcPRpwf0TvA+956LO5P9+n90XK99bsa8d3IveT3H/BF9P76G4
f8r3R9w/5Xsi7p/yfRB5wfvgaNofW/8/3gdRx8h9XGi/K+qjwNfR/lU8H/m9
D/tRKV/g82k/J+9DIn44vOq7xd/f5rpljDtreg/CdQE+lN5HcB8G30nvEbgP
g8+l+T/uw+DmNG/H+JfzbYxz8BY0T0Y8MU/2pv2K9cQ8eTvNk3G/xbyudc+x
3lqfBOyXwnN/YWpzv+PZffl5B36C9kdhPgMe+b5FyJULB3XYX4V5zuDjvrEn
07bzPBzcetOGtaPXzu2G/VLg7rN6z7qb/5jrk+Hfc7LnAm1fE+pLwWd++0df
bf+SF9VBgX/12+OZ2j6lrVRfAT7a5Xl7bT8S1SsyD5n96oPWdxr7SsE/t1k6
UdtfhD4CeO6fSvWu3DBvEtct8z596w2dtHMhUe8KfpPqzbdR3R14P/udf3tM
8KH60mvMT1Nd+Taq8+H9Ob2imzwN8qf6CmO/iqFUP446EPBKD/ammTc6zPUD
4AlUJ96R9jGDr3Bbt/IH3xDer8z7ZKgenPe5En+/qfM3EeWPc78D3Ec7UX03
6tXBHTv9WO35nQ1cTwv+6tjiGTcMz1/UDYLX1B9+lN7AWP8DXjc6ab1//zCu
KwBvuVQ11uZ12I8OHkV10Nh/DN61e1RspXMx3JcB85nXiQ9Of2d4zqJfANcv
Uv0y6uExzzGjfRqoP4d94wZrK2v91VHXCr79YdICTfe0pbwzp3pk1PvxPgTa
R4H6Oth7x1wfp9Wbz6TxAD6A6pFRdwQ/qEdGnQ/sB116bKntj0J9CDjqkVH/
IPdFoN6A7cOeWZg3OsH71Nk/1SNjfzP44F0vv17qd5rHD+aBYVRfjPEDvnXX
xNpB2eu4rpvrGGZU6Pjsji/Xi4KPvTD/habDos4QHHW+q2lcgavU7B8rjzrK
dU3gqOdFPQz4V/OsrlZsGsHjDRx1uxhv4MvejnlTzRAfjDfMA/2D48Oa6Udw
Xwmuc6V6W4w3zA9Rb4t6fthfHV5i+TPD9YU6cHDU26KeGbyK9etzlx13c70l
+D3zyInavBd1euCok0V9F/hJ89lOJ/cc4bog/l1UD4t6Hnz/O6SPoz4E9r3L
m0cMWR/G627cN4XqYbH/G7xt+T8jeidEcJ8UzG8HkB6N8QN+i/Rr3H+kHo36
Xqk74/4j9WXucyX0ZdyXpL7M/ayIPyJ9GeMEPJ30Ze7zQnn4g3RhjBOp52Kc
SD0X40TquRgn4A9It0WdudRnUS8N3ot0WNTZgs8kvXU5/Rnch3RV1PVJ/RTz
QvAFpJNi/EidlOt5hE7K67ZCD8X4kbonxg/yuZHqKzF+wA/2+GGq1gcV4wc8
urBeI4Drw8G9w1r+otUtou4UvPOYf60N731czwZuPX7cbq2eEeMEvCHVIWKc
gFcKv18mqdlZnr8hfjVyyw0Oz1zO44T1ppJF9YMYD+Bjct/4aOfxYTyAn6I6
QYwH8Iojyi5s3Dec69XBu1A9IOqlwafbeFncX3FK/UZxB99FdX+oqwR/UHnT
/UGjznF+WR90H9ahxS8XOY/gtq9rrquwJYnzyH1QqM4O80nwWuf85rzdG8R9
NMC7tN2Utn/5afq9icxfnzsUE1D9IuUrhvNzdXrZLxbPvMr1hOA3vow4cvD+
Da5TYr3mnn5I5Y3pCvd/jNMIv+5XwzM3cr7AP5UpqhfDdY35PK1TcR5h3/vV
8Eit7g955LpVqhfD/R98ev6WNYd7X+B8gR8f8U+k5dI/OC9c3/yg5Z83RqRy
PSTXN5OOgPs57Otb6L/4+tUtzhf4haHb69pvuMt9oPA+kkt1VegrxOvwPWu7
GeYV3I8GfA/VT6GPCXjywtfP40okcf8L7q9MdVLomwC+88Gza+86papTdP8F
b0v1UK6Ud/CrGyZYbXtxW7Wk65DX1anuCXWhvH6+63G3HcNyuJ4QvB/VN6EO
DXzHnIDpTscecB8l7mNH9Ufov8N1Jy5hHvMy4rlvC/h5qjPyobzzuvrrck8d
ht5QmH+CF1A9USCNB15XDz5p7mJ4Lx5D1y/4bKobQj0z+K42UXsGbM7hOljw
pVQf1JbGCfiYjRUjxrg/5Lo7cEV1QKjX4nqagskJM3/hP/P3pPodWbelC7j0
d66f4fl+W6y31xR93sDf/GG2Sm94vmPeBn5G9HMDHzRm9ZdLtf1gYn0+VPRt
A98zZN2N0k7e/Jzgfu0Li/dn43qW3ht3bhrjy/cjuZ7P9ZOoK9qT2HqDtT+P
Y/ARot8ar+eL83fAD9H5O4gbuIM4Zwd/L5Xec8FZFxDn73DdhOi3Bn5cnL8D
/yfpvRic7cW5PKwviD5s4JHiXB74H0Lv0eBczyLO65G6A/LI9SbivB6uZ6H3
bnDWHegcH+SX/YjzeuT7ODj7Eef4SF0D44HjL87xgX8H0jW43wh0HDrfB3YY
Fz3//TXR6YEH5x1c71X10gbDuEW+wKukvt6q7eNFnMHbOeZcqF/rGMeHx91f
ue+1eT5+L/ipmNFbP5aM4d8ldRZ8f/DE5TeaRXY19jvCeJTn14Dj/Br8fXB5
Tg04zqnBeAaX59GA4zwajE9wee4MOM6dwXhjP+J8Ga4bpvNlMK7A5Tky/O/S
OTKIJ7g8L0bqPuCwxzkyiCfisadRq6n3DfdV/H1wj2Pzxnw5bhfHB9z/0UEz
rc4IcQB3+7vqCE1P4X1mxFuanU1PWxvOvwvcd92bz5mrjONf6lDF+9ql68p9
3cLaMF/lccK6kjgnBdyNzknBOAHfJc5Dwe/rSu/jvN5E9l+Jc1LAe4i+WOBv
xTkp4MfpnBSMK/CG4jwU1q3oPBSMK3BLce4JuFn7onNPeH4MnUucbwLuI843
kXoZ8gI+UJxvIvUycNhb07kn3H9bvO//l47GfbbFOgD30xb6GvfTJr6G1ge4
P7ZYH+B+18Rb0ToA900Q7/vcp1rod9ynWuh3XH+L/ariHBDwHnQOCOIA3lec
94HfkU3rAOCwvyrOAQH/R/R94jpycQ6I3L8NDvsBdD4I77+HrifOAZHrCfgz
91+k80F43y3xzeIcEPAAOgcE4xk8VZz3Ab5AnPchdUnkEdxTnPeB76sjXZL3
tZC9OZ0Dgjzid3iMCvk89/am/9Er14g+TuBudSPqhwbuN9ZNCR2T19GIT7Ra
WvLTrlD+ftwHekeDeYd7R3LcwL/evfr+dd1Jjg+42d6CIW+/13EcwCuIPkjc
N+KG1QRtvyXGM3RAeS4G+FU6FwNxAI8X51/g+8bQOgY47B3EuRjgQ0QfJPC+
4lwM7qNM6x7gsO8uzsuQ+izGObiPOC9DrpOAw36bOEdD6rmIL/hGcY4G7/em
czQw/sHdxHkZ4MvFeRngZ0R/JNZ/xXkZ+PdHkv4LDvsYOkcDecf36lHCvmSy
VQDnnb+v6IPE+2+HTPWrdM64vs/7e0W/I/DYIdX8Rp04z3kBHyf6GnEf5ffz
n7SodIV/D3jUkAJft7Y3OG7g9a1q9Xyclcbx4f26or8Q95l7b/dk2DqjTol4
y/MmwCvQeROID/j34lwJfK8NtC4EDvu1dN4E4gY+UZwrAZ5M50ogbuDp4vwI
/p50fgT3XSTuIs6JAA+jcyIQF/A64jwI1uXpPAjEGXy8OPeB+6qSbg4O+/d0
HgTX/5O/B6/altPOeUfcwFOvlGiXsPUSxwfcovLrl8tLGuMAPjBmql3Nk8bf
C+424c7e8LnZ/P3AHVYfXmplblwfAX85csLhv+YY3/dkPxDc32TfD9yXwHtQ
fw/cT3gfIPXxwPUp+3UgXrIvh+ibpFvz9VnrDhlz+D0cPJb6ZmDcgrdZ8vOn
YybzYfA+1AcD4xPcbPEnh6Dsnfy7wHdQXwuMT/CFt51HfnTez79X9qnA+AR/
/OvQstr5y3wfhG5OfScwPsFHm3eN0Pp+Iz7gLtRHAvnj+VpG1TBtHQBx4/fr
3sXPHwc/Tv0cEB/w99S3AXFgPZ36M+D3gu+hPgz4XbLfAn6X1NPxu8Bjqd8C
vj+uj4QxRfs38DvBZT9wcFvqhwCO3yf7hMO+k3oeqb3vwA78IPU9wDgB9/tr
2SXT93HW00U/cPZD/Q3ApS6PcQX7vQnu4abv79z/SfQJB/+J+huAS70e4xD2
qQN7DjZ935d6PfIo+xuASx0f+eU+c5369DJdH+D1UdFXnPszUH8DjGfwtAb9
bLR1A4wH5OEs6fvIL7gj9RnA9wPPo34CiD/X+1PfAMRf6vuIJ/crpb4BiKfU
9xEf2TcA8QE/T/o+4iD7BnC/JOjmbVodNLyX8fgHtxP9tMHNqa4fnPedij7b
sNfn1vIxvQ9wH0eq38f3A9+Uq53jbDy3Anwe1eMjnuB+r9wGa+cgYDyDXxZ9
s8H7Ud094gy+6FWXIVo/B4xb8P2ibzZ4JaqvB8f3vSv6afP6gMuSIC2P/7V/
APkCf0f19Ri3vC/CZcQR1ymRxnPqKR4lSrgN0fYV8HlexPvRegL3eSFehdYN
+Lwt4p8ii+rW+fws4rNp/8B/7Svgc7KIP6T9A3JfAerW+Tws4kdoPQG/S+4r
wPiU+wrwe/+Ly/0GGJ9yvwHiI+vEeX+M2G+AuMl1A/weud8A30PWcSOe/7/7
DRBnWa8NLvchcN/C/899CMgL+C7iGIdyfwLyxX1waX8C4g9+huqmEWfw7lQf
jXjy+zvVQfP6EfFPqUX1zvi9sq5Z7k9oRPsT8LvYnuqa8f0Rb8fdQ98Ynvs8
3sBLiv7GfJ4Y1R1jXHFf5zlHviplcm4p+NdUR4xxBW5VJ6eFtj+c+2IQn011
wRhX4KsK6/5OG/NNPJfqfLlenfjcV0vitPNDeT+0qNtF3MD3OnWvqtWTIm7g
PakOt3if0nR1/WaZKdr7F+IJf/donwPiBl6V6mF5/kS8PdW9Ig6yvhW/V9ax
4nfJelV8f95HQXWp+J64DnYln7Y9YhjPvC+WeEnRF5frNKluFJzf40S/XK6L
TFn65FFODP9e8PZUH4rxAO7v0PjAnwHG8y7Bl1K9J/f7wPpfgmfynNvG9URw
PdVvYjyA79z99tObsmkcN1mPCS73USCOfC5EanB1rS8x7GTdJcYJ+L3y45r/
YpPF8ef1ddpfgXjyPgSqf0Q8wffR/grEk+d3VP+IeIKXpP0ViCf36aT6R8QT
vB3tr0A8Zf0j4in3VyBuvB+D6h8RN/D+tL8CceNzXKn+EfHB+3S02D8APkf0
feX9GFTnyHVcqHNsGGA7rddF435c6Eui7yt4PNU/Ip7gBxPNLqetNfYnAn8s
+r6C51FdJO+DJN7cLeLV69mZ/FzhukjR95V/L9VLIv7gmRbhGz2t7/P9iNez
Rd9XWUeJvID7LSq/f9e3uTxeuZ+q6PvK64VUX8n1usQnpE6MPlLF+GfkM4rq
FP4fEbDEGA==
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
        1596, 614, 1430, 336, 634, 1442, 356, 654, 1455, 376, 674, 1470, 396, 
        694, 1483, 1484, 416, 714, 1500, 436, 734, 1513, 1514, 456, 754, 1532,
         476, 774, 1545, 496, 794, 1557, 516, 1731, 814, 536},
        VertexColors->None], 
       Line3DBox[{267, 557, 1386, 268, 1574, 576, 1403, 298, 596, 318, 1599, 
        616, 1431, 338, 1615, 636, 358, 1629, 656, 1456, 378, 676, 398, 1657, 
        696, 1485, 418, 716, 438, 1682, 736, 1516, 458, 756, 1533, 478, 1704, 
        776, 1546, 498, 1718, 796, 518, 1733, 816, 538},
        VertexColors->None], 
       Line3DBox[{269, 558, 1387, 271, 577, 1404, 1405, 299, 597, 1420, 319, 
        1600, 617, 1432, 339, 637, 1443, 359, 1630, 657, 1457, 379, 677, 1471,
         399, 697, 1486, 1487, 419, 717, 1501, 439, 737, 1517, 1518, 459, 757,
         1534, 479, 777, 1547, 499, 797, 1558, 519, 1734, 817, 539},
        VertexColors->None], 
       Line3DBox[{273, 560, 1388, 274, 1576, 579, 1407, 301, 599, 321, 1603, 
        619, 1433, 341, 1617, 639, 361, 1632, 659, 1458, 381, 1645, 679, 401, 
        1659, 699, 1488, 421, 719, 441, 1684, 739, 1520, 461, 759, 481, 1706, 
        779, 1548, 501, 1720, 799, 521, 1736, 819, 541},
        VertexColors->None], 
       Line3DBox[{275, 561, 1389, 277, 580, 1408, 1409, 302, 600, 1421, 322, 
        1604, 620, 1434, 342, 640, 1444, 362, 1633, 660, 1459, 382, 680, 1472,
         402, 1660, 700, 1489, 422, 720, 1502, 442, 740, 1521, 462, 760, 1535,
         482, 780, 1549, 502, 800, 1559, 522, 1737, 820, 542},
        VertexColors->None], 
       Line3DBox[{279, 563, 1390, 280, 1578, 582, 1410, 304, 1587, 602, 324, 
        1607, 622, 1435, 344, 1619, 642, 364, 1636, 662, 1460, 384, 1647, 682,
         404, 1663, 702, 1490, 424, 1673, 722, 444, 1686, 742, 1522, 464, 762,
         484, 1709, 782, 1550, 504, 1722, 802, 524, 1739, 822, 544},
        VertexColors->None], 
       Line3DBox[{281, 564, 1391, 283, 583, 1411, 1412, 305, 603, 1422, 325, 
        1608, 623, 1436, 345, 643, 1445, 365, 1637, 663, 1461, 385, 683, 1473,
         405, 1664, 703, 1491, 425, 723, 1503, 445, 743, 1523, 465, 763, 1536,
         485, 783, 1551, 505, 803, 1560, 525, 1740, 823, 545},
        VertexColors->None], 
       Line3DBox[{285, 566, 1392, 286, 1580, 585, 1414, 307, 605, 1423, 327, 
        1610, 625, 1437, 347, 645, 1446, 367, 1639, 665, 1463, 387, 685, 1474,
         407, 1666, 705, 1493, 427, 725, 1504, 447, 1688, 745, 1525, 467, 765,
         1537, 487, 1711, 785, 1552, 507, 805, 527, 1742, 825, 547},
        VertexColors->None], 
       Line3DBox[{287, 827, 1743, 828, 288, 586, 1415, 1416, 308, 606, 1424, 
        328, 626, 1438, 1439, 348, 646, 1447, 368, 666, 1464, 1465, 388, 686, 
        1475, 408, 706, 1494, 1495, 428, 726, 1505, 448, 746, 1526, 1527, 468,
         766, 1538, 488, 786, 1553, 1554, 508, 806, 1561, 528, 830, 831, 832},
        VertexColors->None], 
       Line3DBox[{529, 807, 829, 1724, 509, 787, 1712, 489, 1539, 767, 1696, 
        469, 747, 1689, 449, 1506, 727, 1675, 429, 707, 1667, 409, 1476, 687, 
        1649, 389, 667, 1640, 369, 1448, 647, 1621, 349, 627, 1611, 329, 1425,
         607, 1589, 309, 587, 1581, 289, 1393, 567, 1568, 250, 548, 826, 833},
        VertexColors->None], 
       Line3DBox[{531, 809, 1726, 511, 789, 1713, 491, 769, 1699, 1698, 471, 
        749, 1690, 451, 729, 1677, 431, 709, 1668, 411, 689, 1652, 1651, 391, 
        669, 1641, 371, 649, 1624, 1623, 351, 629, 1612, 331, 609, 1592, 1591,
         311, 589, 1582, 291, 569, 1569, 254, 550, 1562, 252},
        VertexColors->None], 
       Line3DBox[{534, 812, 1729, 514, 792, 1715, 494, 772, 1701, 474, 752, 
        1691, 454, 1511, 732, 1679, 434, 712, 1669, 414, 1481, 692, 1654, 394,
         672, 1642, 374, 1453, 652, 1626, 354, 632, 1613, 334, 612, 1594, 314,
         592, 1583, 294, 1398, 572, 1571, 260, 553, 1563, 258},
        VertexColors->None], 
       Line3DBox[{537, 815, 1732, 517, 795, 1717, 497, 775, 1703, 477, 755, 
        1692, 457, 1515, 735, 1681, 437, 715, 1670, 417, 695, 1656, 397, 675, 
        1643, 377, 655, 1628, 357, 635, 1614, 337, 615, 1598, 1597, 317, 595, 
        1584, 297, 1402, 575, 1573, 266, 556, 1564, 264},
        VertexColors->None], 
       Line3DBox[{540, 818, 1735, 520, 798, 1719, 500, 778, 1705, 480, 758, 
        1693, 460, 1519, 738, 1683, 440, 718, 1671, 420, 698, 1658, 400, 678, 
        1644, 380, 658, 1631, 360, 638, 1616, 340, 618, 1602, 1601, 320, 598, 
        1585, 300, 1406, 578, 1575, 272, 559, 1565, 270},
        VertexColors->None], 
       Line3DBox[{543, 821, 1738, 523, 801, 1721, 503, 781, 1708, 1707, 483, 
        761, 1694, 463, 741, 1685, 443, 721, 1672, 423, 701, 1662, 1661, 403, 
        681, 1646, 383, 661, 1635, 1634, 363, 641, 1618, 343, 621, 1606, 1605,
         323, 601, 1586, 303, 581, 1577, 278, 562, 1566, 276},
        VertexColors->None], 
       Line3DBox[{546, 824, 1741, 526, 804, 1723, 506, 784, 1710, 486, 764, 
        1695, 466, 1524, 744, 1687, 446, 724, 1674, 426, 1492, 704, 1665, 406,
         684, 1648, 386, 1462, 664, 1638, 366, 644, 1620, 346, 624, 1609, 326,
         604, 1588, 306, 1413, 584, 1579, 284, 565, 1567, 282},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzFmnk81tu3xynNpMGhSdFEgxBKUotIQqh0KlJIKimKIidFkyGSqSSEzHLM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     "],
    VertexNormals->CompressedData["
1:eJx03Hc81W/4OH6lRVRSskpJ0lAqhHAphbSVUUq2llE0JRKpVGYlMyMzO2Re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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.7921197084679675`*^9, 3.792119734930391*^9}, 
   3.7921198410800066`*^9, {3.7921198727230515`*^9, 3.7921199286879544`*^9}, 
   3.792119969887064*^9, 3.792120044539777*^9, {3.7921200899177914`*^9, 
   3.7921201436091766`*^9}, 3.792120190858268*^9, 3.792120302030509*^9, 
   3.7921203617311883`*^9, {3.792120412740569*^9, 3.7921204255862503`*^9}, 
   3.7921205663093386`*^9, {3.792120661614998*^9, 3.792120673697646*^9}, 
   3.7921207373090696`*^9, {3.792120816267189*^9, 3.7921208327383156`*^9}, {
   3.7921208992160864`*^9, 3.792120963235319*^9}, {3.792121003260561*^9, 
   3.7921211080705037`*^9}, 3.792121589983837*^9, 3.7923271827076316`*^9, {
   3.7923272147703886`*^9, 3.792327236586027*^9}, 3.792331080189366*^9, 
   3.7923312354729233`*^9, 3.7923312755838013`*^9, 3.792331412719743*^9, 
   3.7923319997377305`*^9, 3.79233205419265*^9, 3.792332092405785*^9, 
   3.7923322051768866`*^9, 3.792332402365515*^9, 3.792332643035705*^9, 
   3.7923339273323035`*^9, 3.792334069329567*^9, {3.792339909604049*^9, 
   3.792339929682852*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3 = N3,L - \\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N6 - \
\\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)N7 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N3 = N3,L - \!\(\*FractionBox[\(1\), \(2\)]\)N6 - \!\(\*FractionBox[\(1\), \
\(2\)]\)N7 = ", 
   Rational[1, 4] (1 + $CellContext`\[Eta]) (
    1 + $CellContext`\[Xi]) (-1 + $CellContext`\[Eta] + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.792120412506194*^9, 3.792120425398751*^9}, 
   3.7921205661087875`*^9, {3.7921206614301023`*^9, 3.792120673510146*^9}, 
   3.7921207370590672`*^9, {3.79212081607969*^9, 3.7921208325508165`*^9}, {
   3.7921208989660854`*^9, 3.7921209630504136`*^9}, {3.792121003041813*^9, 
   3.792121107898628*^9}, 3.792121589796336*^9, 3.7923271824264083`*^9, {
   3.7923272145204096`*^9, 3.7923272364141684`*^9}, 3.7923310799464593`*^9, 
   3.792331235238569*^9, 3.7923312754275656`*^9, 3.792331412516633*^9, 
   3.7923319995487366`*^9, 3.792332054018178*^9, 3.7923320922387886`*^9, 
   3.792332204977419*^9, 3.792332402146779*^9, 3.7923326428416977`*^9, 
   3.792333927174308*^9, 3.7923340691495695`*^9, {3.7923399091070623`*^9, 
   3.792339929682852*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJyNnXmczfX3xyciSSlbSYWWsVSyZu+NlCX7V7KWZEmyK2SJISkq+zp2MaRp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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmgn8FdP7x+feM2csodJCRJJoIUXRHtmyRCVLElIh7QulUpJESqUipCKi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           "]], Polygon3DBox[CompressedData["
1:eJwtmwn4F9MXxmfm3vlSWmwRIqUsJUqyRSplL0LSgiiyFkXWUiiSShEp2hOl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           "]], Polygon3DBox[CompressedData["
1:eJwtmGXYVkUQhl/Oe/aVkO7uRkK6EQQERGmkQzqlPxo+KUGkuzuku6VDRWmQ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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0s1L03EAx/HvNjeXy2nNrPXg1M6FYMeEwqMPxLwVXbyZ1a4Fgt70LyiM
rgVC3vQvKIro5sN0M3sgQnq6uCyloF5f8PDm9WEbv/1+361nvFK+mwghzOuX
4t7VJw2mQmhnmWMq2RVe5DRnNGA/5jCfcVE37Ne8xRrruh+vzzlmmkJo1kP7
PJ+yn5e0bF/jC77hDve1qp/6rmPJENZ4nAWt2x2s8gQ7tWGf5CZPsaiafZp1
nuFZbdnn+JZdLGnb7uY79rBX7+O98gOveI4vPNBH7emHJt3vCm/yOUc5oiW7
j0/i9ditB3aKs/G5XK+he3aVE3zFl7puL3CIjzivy/YUL/AOb6srnrnrfeZv
tamhbyr5UfPxOdkaz4BFHY1nxFw8PxbUEs+XR5iPn1fWzrGZ2agydpppJpmQ
rw//4nPpr/7E93TVC18P/1//AX/HRZs=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{835, 1223, 548, 834, 1381, 1229, 1562, 836, 1382, 1132, 837,
         1383, 1230, 1563, 838, 1384, 1133, 839, 1385, 1231, 1564, 840, 1386, 
        1134, 841, 1387, 1232, 1565, 842, 1388, 1135, 843, 1389, 1233, 1566, 
        844, 1390, 1136, 845, 1391, 1234, 1567, 846, 1392, 1137, 847, 1743, 
        1224, 1138, 1225},
        VertexColors->None], 
       Line3DBox[{851, 1393, 1139, 849, 1394, 569, 853, 1395, 1140, 855, 1397,
         1398, 1141, 857, 1399, 1142, 859, 1401, 1402, 1143, 861, 1403, 1144, 
        863, 1405, 1406, 1145, 865, 1407, 1146, 867, 1409, 581, 869, 1410, 
        1147, 871, 1412, 1413, 1148, 873, 1414, 1149, 875, 1416, 1151, 877},
        VertexColors->None], 
       Line3DBox[{876, 1150, 1415, 874, 1580, 1246, 872, 1579, 1245, 1411, 
        870, 1578, 1244, 868, 1577, 1243, 1408, 866, 1576, 1242, 864, 1575, 
        1241, 1404, 862, 1574, 1240, 860, 1573, 1239, 1400, 858, 1572, 1238, 
        856, 1571, 1237, 1396, 854, 1570, 1236, 852, 1569, 568, 848, 1568, 
        1235, 850},
        VertexColors->None], 
       Line3DBox[{879, 1247, 1581, 878, 1417, 1248, 1582, 880, 590, 881, 1418,
         1249, 1583, 882, 593, 883, 1419, 1250, 1584, 884, 596, 885, 1420, 
        1251, 1585, 886, 599, 887, 1421, 1252, 1586, 888, 1253, 1587, 889, 
        1422, 1254, 1588, 890, 1423, 1152, 891, 1424, 1153, 892},
        VertexColors->None], 
       Line3DBox[{896, 1425, 1154, 894, 1426, 1257, 1592, 898, 1427, 1155, 
        900, 1428, 612, 902, 1429, 1156, 904, 1430, 1261, 1598, 906, 1431, 
        1157, 908, 1432, 1264, 1602, 910, 1433, 1158, 912, 1434, 1267, 1606, 
        914, 1435, 1159, 916, 1436, 624, 918, 1437, 1160, 920, 1439, 1162, 
        922},
        VertexColors->None], 
       Line3DBox[{921, 1161, 1438, 919, 1610, 1270, 917, 1609, 1608, 1269, 
        915, 1607, 1268, 913, 1605, 1604, 1266, 911, 1603, 1265, 909, 1601, 
        1600, 1263, 907, 1599, 1262, 905, 1597, 1596, 1260, 903, 1595, 1259, 
        901, 1594, 611, 899, 1593, 1258, 897, 1591, 1590, 1256, 893, 1589, 
        1255, 895},
        VertexColors->None], 
       Line3DBox[{924, 1271, 1611, 923, 1440, 1272, 1612, 925, 630, 926, 1441,
         1273, 1613, 927, 633, 928, 1442, 1274, 1614, 929, 1275, 1615, 930, 
        1443, 1276, 1616, 931, 1277, 1617, 932, 1444, 1278, 1618, 933, 1279, 
        1619, 934, 1445, 1280, 1620, 935, 1446, 1163, 936, 1447, 1164, 937},
        VertexColors->None], 
       Line3DBox[{941, 1448, 1165, 939, 1449, 1283, 1624, 943, 1450, 1166, 
        945, 1452, 1453, 1167, 947, 1454, 1168, 949, 1455, 655, 951, 1456, 
        1169, 953, 1457, 658, 955, 1458, 1170, 957, 1459, 1291, 1635, 959, 
        1460, 1171, 961, 1461, 1462, 1172, 963, 1463, 1173, 965, 1465, 1175, 
        967},
        VertexColors->None], 
       Line3DBox[{966, 1174, 1464, 964, 1639, 1294, 962, 1638, 1637, 1293, 
        960, 1636, 1292, 958, 1634, 1633, 1290, 956, 1632, 1289, 954, 1631, 
        1630, 1288, 952, 1629, 1287, 950, 1628, 654, 948, 1627, 1286, 946, 
        1626, 1285, 1451, 944, 1625, 1284, 942, 1623, 1622, 1282, 938, 1621, 
        1281, 940},
        VertexColors->None], 
       Line3DBox[{969, 1295, 1640, 968, 1466, 1296, 1641, 970, 1467, 1176, 
        971, 1468, 1297, 1642, 972, 1469, 1177, 973, 1470, 1298, 1643, 974, 
        676, 975, 1471, 1299, 1644, 976, 1300, 1645, 977, 1472, 1301, 1646, 
        978, 1302, 1647, 979, 1473, 1303, 1648, 980, 1474, 1178, 981, 1475, 
        1179, 982},
        VertexColors->None], 
       Line3DBox[{986, 1476, 1180, 984, 1477, 1306, 1652, 988, 1478, 1181, 
        990, 1480, 1481, 1182, 992, 1482, 1183, 994, 1484, 695, 996, 1485, 
        1184, 998, 1487, 698, 1000, 1488, 1185, 1002, 1489, 1315, 1662, 1004, 
        1490, 1186, 1006, 1491, 1492, 1187, 1008, 1493, 1188, 1010, 1495, 
        1190, 1012},
        VertexColors->None], 
       Line3DBox[{1011, 1189, 1494, 1009, 1666, 1318, 1007, 1665, 1664, 1317, 
        1005, 1663, 1316, 1003, 1661, 1660, 1314, 1001, 1659, 1313, 999, 1658,
         1312, 1486, 997, 1657, 1311, 995, 1656, 1310, 1483, 993, 1655, 1309, 
        991, 1654, 1308, 1479, 989, 1653, 1307, 987, 1651, 1650, 1305, 983, 
        1649, 1304, 985},
        VertexColors->None], 
       Line3DBox[{1014, 1319, 1667, 1013, 1496, 1320, 1668, 1015, 1497, 1191, 
        1016, 1498, 1321, 1669, 1017, 1499, 1192, 1018, 1500, 1322, 1670, 
        1019, 716, 1020, 1501, 1323, 1671, 1021, 719, 1022, 1502, 1324, 1672, 
        1023, 1325, 1673, 1024, 1503, 1326, 1674, 1025, 1504, 1193, 1026, 
        1505, 1194, 1027},
        VertexColors->None], 
       Line3DBox[{1031, 1506, 1195, 1029, 1507, 729, 1033, 1508, 1196, 1035, 
        1510, 1511, 1197, 1037, 1512, 1198, 1039, 1514, 1515, 1199, 1041, 
        1516, 1200, 1043, 1518, 1519, 1201, 1045, 1520, 1202, 1047, 1521, 741,
         1049, 1522, 1203, 1051, 1523, 1524, 1204, 1053, 1525, 1205, 1055, 
        1527, 1207, 1057},
        VertexColors->None], 
       Line3DBox[{1056, 1206, 1526, 1054, 1688, 1337, 1052, 1687, 743, 1050, 
        1686, 1336, 1048, 1685, 740, 1046, 1684, 1335, 1044, 1683, 1334, 1517,
         1042, 1682, 1333, 1040, 1681, 1332, 1513, 1038, 1680, 1331, 1036, 
        1679, 1330, 1509, 1034, 1678, 1329, 1032, 1677, 1676, 1328, 1028, 
        1675, 1327, 1030},
        VertexColors->None], 
       Line3DBox[{1059, 1338, 1689, 1058, 1528, 1339, 1690, 1060, 1529, 1208, 
        1061, 1530, 1340, 1691, 1062, 1531, 1209, 1063, 1532, 1341, 1692, 
        1064, 1533, 1210, 1065, 1534, 1342, 1693, 1066, 759, 1067, 1535, 1343,
         1694, 1068, 762, 1069, 1536, 1344, 1695, 1070, 1537, 1211, 1071, 
        1538, 1212, 1072},
        VertexColors->None], 
       Line3DBox[{1076, 1539, 1213, 1074, 1540, 1347, 1699, 1078, 1541, 1214, 
        1080, 1543, 772, 1082, 1544, 1215, 1084, 1545, 775, 1086, 1546, 1216, 
        1088, 1547, 778, 1090, 1548, 1217, 1092, 1549, 1353, 1708, 1094, 1550,
         1218, 1096, 1551, 784, 1098, 1552, 1219, 1100, 1554, 1221, 1102},
        VertexColors->None], 
       Line3DBox[{1101, 1220, 1553, 1099, 1711, 1355, 1097, 1710, 783, 1095, 
        1709, 1354, 1093, 1707, 780, 1091, 1706, 1352, 1089, 1705, 777, 1087, 
        1704, 1351, 1085, 1703, 774, 1083, 1702, 1350, 1081, 1701, 1349, 1542,
         1079, 1700, 1348, 1077, 1698, 1697, 1346, 1073, 1696, 1345, 1075},
        VertexColors->None], 
       Line3DBox[{1104, 1356, 1712, 1103, 1555, 1357, 1713, 1105, 1358, 1714, 
        1106, 1556, 1359, 1715, 1107, 1360, 1716, 1108, 1557, 1361, 1717, 
        1109, 1362, 1718, 1110, 1558, 1363, 1719, 1111, 1364, 1720, 1112, 
        1559, 1365, 1721, 1113, 1366, 1722, 1114, 1560, 1367, 1723, 1115, 805,
         1116, 1561, 1222, 1117},
        VertexColors->None], 
       Line3DBox[{1131, 1228, 830, 1130, 1742, 1379, 1129, 1741, 1740, 1378, 
        1128, 1739, 1377, 1127, 1738, 1737, 1376, 1126, 1736, 1375, 1125, 
        1735, 1734, 1374, 1124, 1733, 1373, 1123, 1732, 1731, 1372, 1122, 
        1730, 1371, 1121, 1729, 1728, 1370, 1120, 1727, 1369, 1119, 1726, 
        1725, 1368, 1118, 1380, 1724, 1226, 1227},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 549, 1381, 253, 568, 1394, 290, 588, 1417, 310, 1590, 
        608, 1426, 330, 628, 1440, 350, 1622, 648, 1449, 370, 668, 1466, 390, 
        1650, 688, 1477, 410, 708, 1496, 430, 1676, 728, 1507, 450, 748, 1528,
         470, 1697, 768, 1540, 490, 788, 1555, 510, 1725, 808, 530},
        VertexColors->None], 
       Line3DBox[{255, 551, 1382, 256, 1570, 570, 1395, 292, 590, 312, 1593, 
        610, 1427, 332, 630, 352, 1625, 650, 1450, 372, 670, 1467, 392, 1653, 
        690, 1478, 412, 710, 1497, 432, 1678, 730, 1508, 452, 750, 1529, 472, 
        1700, 770, 1541, 492, 1714, 790, 512, 1727, 810, 532},
        VertexColors->None], 
       Line3DBox[{257, 552, 1383, 259, 571, 1396, 1397, 293, 591, 1418, 313, 
        611, 1428, 333, 631, 1441, 353, 651, 1451, 1452, 373, 671, 1468, 393, 
        691, 1479, 1480, 413, 711, 1498, 433, 731, 1509, 1510, 453, 751, 1530,
         473, 771, 1542, 1543, 493, 791, 1556, 513, 1728, 811, 533},
        VertexColors->None], 
       Line3DBox[{261, 554, 1384, 262, 1572, 573, 1399, 295, 593, 315, 1595, 
        613, 1429, 335, 633, 355, 1627, 653, 1454, 375, 673, 1469, 395, 1655, 
        693, 1482, 415, 713, 1499, 435, 1680, 733, 1512, 455, 753, 1531, 475, 
        1702, 773, 1544, 495, 1716, 793, 515, 1730, 813, 535},
        VertexColors->None], 
       Line3DBox[{263, 555, 1385, 265, 574, 1400, 1401, 296, 594, 1419, 316, 
    